/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.representation.Form;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.web.resources.RouteResource;

public class RouteStatusResource {
    private RouteResource routeResource;

    public RouteStatusResource(RouteResource routeResource) {
        this.routeResource = routeResource;
    }

    public RouteDefinition getRoute() {
        return this.routeResource.getRoute();
    }

    public CamelContext getCamelContext() {
        return this.routeResource.getCamelContext();
    }

    @GET
    @Produces(value={"text/plain"})
    public String getStatusText() {
        ServiceStatus status = this.getStatus();
        if (status != null) {
            return status.toString();
        }
        return null;
    }

    public ServiceStatus getStatus() {
        return this.getRoute().getStatus();
    }

    @POST
    @Consumes(value={"text/plain"})
    public Response setStatus(String status) throws Exception {
        if (status != null) {
            if (status.equalsIgnoreCase("start")) {
                this.getCamelContext().startRoute(this.getRoute());
                return Response.ok().build();
            }
            if (status.equalsIgnoreCase("stop")) {
                this.getCamelContext().stopRoute(this.getRoute());
                return Response.ok().build();
            }
        }
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response setStatus(Form formData) throws Exception {
        System.out.println("Received form! " + formData);
        String status = (String)formData.getFirst("status", String.class);
        this.setStatus(status);
        return Response.seeOther((URI)new URI("/routes")).build();
    }
}

