/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class Lookup {
    public static final Lookup EMPTY = new Empty();
    private static Lookup defaultLookup;
    static /* synthetic */ Class class$java$lang$Object;

    public static synchronized Lookup getDefault() {
        if (defaultLookup != null) {
            return defaultLookup;
        }
        String string = System.getProperty("org.openide.util.Lookup");
        if ("-".equals(string)) {
            return EMPTY;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (string != null) {
                defaultLookup = (Lookup)Class.forName(string, true, classLoader).newInstance();
                return defaultLookup;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Lookup lookup = Lookups.metaInfServices(classLoader);
        defaultLookup = (Lookup)lookup.lookup(Lookup.class);
        if (defaultLookup != null) {
            return defaultLookup;
        }
        Provider provider = (Provider)lookup.lookup(Provider.class);
        if (provider != null) {
            defaultLookup = Lookups.proxy(provider);
            return defaultLookup;
        }
        Lookup lookup2 = Lookups.singleton(classLoader);
        defaultLookup = new ProxyLookup(new Lookup[]{lookup, lookup2});
        return defaultLookup;
    }

    public abstract Object lookup(Class var1);

    public abstract Result lookup(Template var1);

    public Item lookupItem(Template template) {
        Result result = this.lookup(template);
        Iterator iterator = result.allItems().iterator();
        return iterator.hasNext() ? (Item)iterator.next() : null;
    }

    private static final class Empty
    extends Lookup {
        private static final Result NO_RESULT = new Result(){

            public void addLookupListener(LookupListener lookupListener) {
            }

            public void removeLookupListener(LookupListener lookupListener) {
            }

            public Collection allInstances() {
                return Collections.EMPTY_SET;
            }
        };

        Empty() {
        }

        public Object lookup(Class clazz) {
            return null;
        }

        public Result lookup(Template template) {
            return NO_RESULT;
        }
    }

    public static abstract class Item {
        public abstract Object getInstance();

        public abstract Class getType();

        public abstract String getId();

        public abstract String getDisplayName();

        public String toString() {
            return this.getId();
        }
    }

    public static abstract class Result {
        public abstract void addLookupListener(LookupListener var1);

        public abstract void removeLookupListener(LookupListener var1);

        public abstract Collection allInstances();

        public Set allClasses() {
            return Collections.EMPTY_SET;
        }

        public Collection allItems() {
            return Collections.EMPTY_SET;
        }
    }

    public static final class Template {
        private int hashCode;
        private Class type;
        private String id;
        private Object instance;

        public Template() {
            this(null);
        }

        public Template(Class clazz) {
            this(clazz, null, null);
        }

        public Template(Class clazz, String string, Object object) {
            Class clazz2 = clazz == null ? (class$java$lang$Object == null ? (class$java$lang$Object = Lookup.class$("java.lang.Object")) : class$java$lang$Object) : clazz;
            this.type = clazz2;
            this.id = string;
            this.instance = object;
        }

        public Class getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Object getInstance() {
            return this.instance;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = (this.type == null ? 1 : this.type.hashCode()) + (this.id == null ? 2 : this.id.hashCode()) + (this.instance == null ? 3 : 0);
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Template)) {
                return false;
            }
            Template template = (Template)object;
            if (this.hashCode() != template.hashCode()) {
                return false;
            }
            if (this.type != template.type) {
                return false;
            }
            if (this.id == null ? template.id != null : !this.id.equals(template.id)) {
                return false;
            }
            if (this.instance == null) {
                return template.instance == null;
            }
            return this.instance.equals(template.instance);
        }

        public String toString() {
            return "Lookup.Template[type=" + this.type + ",id=" + this.id + ",instance=" + this.instance + "]";
        }
    }

    public static interface Provider {
        public Lookup getLookup();
    }
}

