/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.sitemesh.compatability;

import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.HttpContentType;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.compatability.HTMLPage2Content;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

public class PageParser2ContentProcessor
implements ContentProcessor {
    private final Factory factory;

    public PageParser2ContentProcessor(Factory factory) {
        this.factory = factory;
    }

    @Override
    public boolean handles(SiteMeshContext context) {
        SiteMeshWebAppContext webAppContext = (SiteMeshWebAppContext)context;
        return !this.factory.isPathExcluded(this.extractRequestPath(webAppContext.getRequest()));
    }

    private String extractRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        return (servletPath == null ? "" : servletPath) + (pathInfo == null ? "" : pathInfo) + (String)(query == null ? "" : "?" + query);
    }

    @Override
    public boolean handles(String contentType) {
        return this.factory.shouldParsePage(contentType);
    }

    @Override
    public Content build(char[] data, SiteMeshContext context) throws IOException {
        HttpContentType httpContentType = new HttpContentType(context.getContentType());
        PageParser pageParser = this.factory.getPageParser(httpContentType.getType());
        Page page = pageParser.parse(data);
        return new HTMLPage2Content((HTMLPage)page);
    }
}

