/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.rule.design;

import net.sourceforge.pmd.lang.vm.ast.ASTElseIfStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTprocess;
import net.sourceforge.pmd.lang.vm.ast.AbstractVmNode;
import net.sourceforge.pmd.lang.vm.rule.AbstractVmRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractVmRule {
    private int depth;
    private int depthLimit;
    private static final PropertyDescriptor<Integer> PROBLEM_DEPTH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"problemDepth").desc("The if statement depth reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)3)).build();

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor(PROBLEM_DEPTH_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTprocess node, Object data) {
        this.depth = 0;
        this.depthLimit = (Integer)this.getProperty(PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        return this.handleIf(node, data);
    }

    @Override
    public Object visit(ASTElseIfStatement node, Object data) {
        return this.handleIf(node, data);
    }

    private Object handleIf(AbstractVmNode node, Object data) {
        ++this.depth;
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, node);
        }
        --this.depth;
        return data;
    }
}

