/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.lang.java.types.internal.infer.OverloadSet;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailedException;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;

final class PhaseOverloadSet
extends OverloadSet<ExprMirror.InvocationMirror.MethodCtDecl> {
    private final Infer infer;
    private final MethodResolutionPhase phase;
    private final MethodCallSite site;

    PhaseOverloadSet(Infer infer, MethodResolutionPhase phase, MethodCallSite site) {
        this.infer = infer;
        this.phase = phase;
        this.site = site;
    }

    public MethodResolutionPhase getPhase() {
        return this.phase;
    }

    public MethodCallSite getSite() {
        return this.site;
    }

    public Infer getInfer() {
        return this.infer;
    }

    @Override
    void add(ExprMirror.InvocationMirror.MethodCtDecl sig) {
        super.add(sig);
    }

    public @NonNull ExprMirror.InvocationMirror.MethodCtDecl getMostSpecificOrLogAmbiguity(TypeInferenceLogger logger) {
        assert (this.nonEmpty());
        List<ExprMirror.InvocationMirror.MethodCtDecl> overloads = this.getOverloadsMutable();
        ExprMirror.InvocationMirror.MethodCtDecl main = (ExprMirror.InvocationMirror.MethodCtDecl)overloads.get(0);
        if (overloads.size() != 1) {
            logger.ambiguityError(this.site, main, overloads);
            main = main.asFailed();
        }
        return main;
    }

    @Override
    protected OptionalBool shouldTakePrecedence(ExprMirror.InvocationMirror.MethodCtDecl m1, ExprMirror.InvocationMirror.MethodCtDecl m2) {
        return this.isMoreSpecific(m1.getMethodType().internalApi().adaptedMethod(), m2.getMethodType().internalApi().adaptedMethod());
    }

    private OptionalBool isMoreSpecific(@NonNull JMethodSig m1, @NonNull JMethodSig m2) {
        OptionalBool m1OverM2 = this.isMoreSpecificForExpr(m1, m2);
        if (m1OverM2.isKnown()) {
            return m1OverM2;
        }
        if (TypeOps.areOverrideEquivalent(m1, m2)) {
            JTypeMirror observingSite = ((ExprMirror.InvocationMirror)this.site.getExpr()).getReceiverType();
            if (observingSite == null) {
                observingSite = ((ExprMirror.InvocationMirror)this.site.getExpr()).getEnclosingType();
            }
            return OverloadSet.shouldAlwaysTakePrecedence(m1, m2, observingSite);
        }
        return OptionalBool.UNKNOWN;
    }

    private OptionalBool isMoreSpecificForExpr(JMethodSig m1, JMethodSig m2) {
        boolean m2OverM1;
        boolean m1OverM2 = this.isInferredMoreSpecific(m1, m2);
        if (m1OverM2 ^ (m2OverM1 = this.isInferredMoreSpecific(m2, m1))) {
            return OptionalBool.definitely((boolean)m1OverM2);
        }
        return OptionalBool.UNKNOWN;
    }

    private boolean isInferredMoreSpecific(JMethodSig m1, JMethodSig m2) {
        try {
            return this.doInfer(m1, m2);
        }
        catch (ResolutionFailedException e) {
            return false;
        }
    }

    private boolean doInfer(JMethodSig m1, JMethodSig m2) {
        MethodCallSite site = this.site.cloneForSpecificityCheck(this.infer);
        InferenceContext ctx = this.infer.newContextFor(m2);
        JMethodSig m2p = ctx.mapToIVars(m2);
        List<ExprMirror> es = ((ExprMirror.InvocationMirror)site.getExpr()).getArgumentExpressions();
        List<JTypeMirror> m1Formals = m1.getFormalParameters();
        List<JTypeMirror> m2Formals = m2p.getFormalParameters();
        int k = es.size();
        for (int i = 0; i < k; ++i) {
            JTypeMirror ti = this.phase.ithFormal(m2Formals, i);
            JTypeMirror si = this.phase.ithFormal(m1Formals, i);
            ExprMirror ei = es.get(i);
            if (si.equals(ti)) continue;
            if (this.unresolvedTypeFallback(si, ti, ei) == OptionalBool.NO) {
                return false;
            }
            if (si.isSubtypeOf(ti)) {
                return true;
            }
            if (ti.isSubtypeOf(si)) {
                return false;
            }
            JMethodSig sfun = TypeOps.findFunctionalInterfaceMethod(si);
            JMethodSig tfun = TypeOps.findFunctionalInterfaceMethod(ti);
            if (sfun == null || tfun == null) {
                JTypeMirror stdExprTy;
                if (this.phase.canBox() && (stdExprTy = ei.getStandaloneType()) != null && stdExprTy.isPrimitive() != si.isPrimitive() && stdExprTy.isPrimitive() != ti.isPrimitive()) {
                    if (stdExprTy.box().equals(si.box())) {
                        return true;
                    }
                    if (stdExprTy.box().equals(ti.box())) {
                        return false;
                    }
                }
                this.infer.checkConvertibleOrDefer(ctx, si, ti, ei, this.phase, site);
                continue;
            }
            if (this.isFunctionTypeMoreSpecific(ctx, si, sfun, tfun, ei, site)) continue;
            return false;
        }
        if (this.phase.requiresVarargs() && m2Formals.size() == k + 1) {
            this.infer.checkConvertibleOrDefer(ctx, this.phase.ithFormal(m1Formals, k), m2Formals.get(k), (ExprMirror)site.getExpr(), this.phase, site);
        }
        ctx.solve();
        ctx.callListeners();
        return true;
    }

    private @NonNull OptionalBool unresolvedTypeFallback(JTypeMirror si, JTypeMirror ti, ExprMirror argExpr) {
        JTypeMirror standalone = argExpr.getStandaloneType();
        if (standalone != null && TypeOps.isUnresolved(standalone)) {
            if (standalone.equals(si)) {
                return OptionalBool.YES;
            }
            if (standalone.equals(ti)) {
                return OptionalBool.NO;
            }
        }
        return OptionalBool.UNKNOWN;
    }

    private boolean isFunctionTypeMoreSpecific(InferenceContext ctx, JTypeMirror si, JMethodSig sfun, JMethodSig tfun, ExprMirror ei, MethodCallSite site) {
        if (sfun.getArity() != tfun.getArity() || sfun.getTypeParameters().size() != tfun.getTypeParameters().size()) {
            return false;
        }
        JMethodSig capturedSFun = TypeOps.findFunctionalInterfaceMethod(TypeConversion.capture(si));
        assert (capturedSFun != null);
        if (!TypeOps.haveSameTypeParams(capturedSFun, sfun)) {
            return false;
        }
        List<JTypeVar> sparams = sfun.getTypeParameters();
        List<JTypeVar> tparams = tfun.getTypeParameters();
        Substitution tToS = Substitution.mapping(tparams, sparams);
        for (int j = 0; j < sparams.size(); ++j) {
            JTypeVar aj = sparams.get(j);
            JTypeVar bj = tparams.get(j);
            JTypeMirror x = aj.getUpperBound();
            JTypeMirror y = bj.getUpperBound();
            if (TypeOps.mentionsAny(x, sfun.getTypeParameters()) && !ctx.isGround(y)) {
                return false;
            }
            TypeOps.isSameTypeInInference(x, (JTypeMirror)y.subst((Function)tToS));
        }
        JTypeMirror rs = sfun.getReturnType();
        JTypeMirror rt = tfun.getReturnType();
        return (!TypeOps.mentionsAny(rs, sparams) || ctx.isGround(rt)) && this.addGenericExprConstraintsRecursive(ctx, ei, rs, rt, tToS, site);
    }

    private boolean addGenericExprConstraintsRecursive(InferenceContext ctx, ExprMirror ei, JTypeMirror rs, JTypeMirror rt, Substitution tToS, MethodCallSite site) {
        if (ei instanceof ExprMirror.LambdaExprMirror) {
            ExprMirror.LambdaExprMirror lambda = (ExprMirror.LambdaExprMirror)ei;
            if (!lambda.isExplicitlyTyped()) {
                return false;
            }
            if (ExprMirror.TypeSpecies.getSpecies(rt) != ExprMirror.TypeSpecies.getSpecies(rs)) {
                ExprMirror.TypeSpecies requiredSpecies = ExprMirror.TypeSpecies.getSpecies(rs);
                boolean sameSpecies = true;
                boolean atLeastOne = false;
                for (ExprMirror rexpr : lambda.getResultExpressions()) {
                    atLeastOne = true;
                    sameSpecies &= requiredSpecies == rexpr.getStandaloneSpecies();
                }
                if (sameSpecies && atLeastOne) {
                    return true;
                }
            }
            this.infer.checkConvertibleOrDefer(ctx, rs, (JTypeMirror)rt.subst((Function)tToS), ei, this.phase, site);
            return true;
        }
        if (ei instanceof ExprMirror.MethodRefMirror) {
            JMethodSig exact = ExprOps.getExactMethod((ExprMirror.MethodRefMirror)ei);
            if (exact == null) {
                return false;
            }
            if (ExprMirror.TypeSpecies.getSpecies(rs) != ExprMirror.TypeSpecies.getSpecies(rt) && ExprMirror.TypeSpecies.getSpecies(exact.getReturnType()) == ExprMirror.TypeSpecies.getSpecies(rs)) {
                return true;
            }
            this.infer.checkConvertibleOrDefer(ctx, rs, (JTypeMirror)rt.subst((Function)tToS), ei, this.phase, site);
            return true;
        }
        if (ei instanceof ExprMirror.BranchingMirror) {
            return ((ExprMirror.BranchingMirror)ei).branchesMatch(e -> this.addGenericExprConstraintsRecursive(ctx, (ExprMirror)e, rs, rt, tToS, site));
        }
        return false;
    }
}

