/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericSigBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureParser;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

class TParamStub
implements JTypeParameterSymbol {
    private final String name;
    private final JTypeParameterOwnerSymbol owner;
    private final JTypeVar typeVar;
    private final String boundSignature;
    private final SignatureParser sigParser;
    private PSet<SymbolicValue.SymAnnot> annotations = HashTreePSet.empty();

    TParamStub(String name, GenericSigBase<?> sig, String bound) {
        this.name = name;
        this.owner = sig.ctx;
        this.sigParser = sig.typeLoader();
        this.boundSignature = bound;
        TypeSystem ts = sig.ctx.getTypeSystem();
        this.typeVar = ts.newTypeVar(this);
    }

    @Override
    public @NonNull String getSimpleName() {
        return this.name;
    }

    @Override
    public JTypeMirror computeUpperBound() {
        return this.sigParser.parseTypeVarBound(this.owner.getLexicalScope(), this.boundSignature);
    }

    @Override
    public JTypeParameterOwnerSymbol getDeclaringSymbol() {
        return this.owner;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getDeclaredAnnotations() {
        return this.annotations;
    }

    void addAnnotation(SymbolicValue.SymAnnot annot) {
        this.annotations = this.annotations.plus((Object)annot);
    }

    @Override
    public JTypeVar getTypeMirror() {
        return this.typeVar;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.owner.getTypeSystem();
    }

    public String toString() {
        return SymbolToStrings.ASM.toString(this);
    }

    public int hashCode() {
        return SymbolEquality.TYPE_PARAM.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        return SymbolEquality.TYPE_PARAM.equals(this, obj);
    }
}

