/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AnnotWrapper
implements SymbolicValue.SymAnnot {
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationClass;
    private final JClassSymbol annotationClassSymbol;

    private AnnotWrapper(JClassSymbol annotationClassSymbol, @NonNull Annotation annotation) {
        this.annotationClassSymbol = annotationClassSymbol;
        this.annotation = annotation;
        this.annotationClass = annotation.annotationType();
    }

    static SymbolicValue.SymAnnot wrap(TypeSystem ts, @NonNull Annotation annotation) {
        JClassSymbol sym = ts.getClassSymbol(annotation.annotationType());
        if (sym == null) {
            return null;
        }
        return new AnnotWrapper(sym, annotation);
    }

    @Override
    public @NonNull JClassSymbol getAnnotationSymbol() {
        return this.annotationClassSymbol;
    }

    @Override
    public @Nullable SymbolicValue getAttribute(String attrName) {
        return Arrays.stream(this.annotationClass.getDeclaredMethods()).filter(it -> it.getName().equals(attrName) && it.getParameterCount() == 0).map(it -> {
            try {
                Object result = it.invoke((Object)this.annotation, new Object[0]);
                return SymbolicValue.of(this.annotationClassSymbol.getTypeSystem(), result);
            }
            catch (Exception ignored) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    @Override
    public boolean valueEquals(Object o) {
        return this.annotation.equals(o);
    }

    @Override
    public boolean equals(Object o) {
        return SymbolEquality.ANNOTATION.equals(this, o);
    }

    public int hashCode() {
        return SymbolEquality.ANNOTATION.hash(this);
    }

    public String toString() {
        return SymbolToStrings.FAKE.toString(this);
    }
}

