/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class ConsecutiveLiteralAppendsRule
extends AbstractJavaRulechainRule {
    private static final Set<Class<?>> BLOCK_PARENTS = new HashSet();
    private static final PropertyDescriptor<Integer> THRESHOLD_DESCRIPTOR;
    private ConsecutiveCounter counter = new ConsecutiveCounter();

    public ConsecutiveLiteralAppendsRule() {
        super(ASTVariableDeclaratorId.class, new Class[0]);
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        Node lastBlock;
        if (!ConsecutiveLiteralAppendsRule.isStringBuilderOrBuffer(node)) {
            return data;
        }
        this.counter.initThreshold((Integer)this.getProperty(THRESHOLD_DESCRIPTOR));
        this.counter.reset();
        this.checkConstructor(data, node);
        Node currentBlock = lastBlock = this.getFirstParentBlock((Node)node);
        for (ASTAssignableExpr.ASTNamedReferenceExpr namedReference : node.getLocalUsages()) {
            currentBlock = this.getFirstParentBlock((Node)namedReference);
            ASTPrimaryExpression current = namedReference;
            while (current.getParent() instanceof ASTMethodCall) {
                ASTMethodCall methodCall = (ASTMethodCall)current.getParent();
                current = methodCall;
                if (JavaRuleUtil.isStringBuilderCtorOrAppend(methodCall)) {
                    if (currentBlock != null && lastBlock != null && !currentBlock.equals(lastBlock) || currentBlock == null ^ lastBlock == null) {
                        this.checkForViolation(data);
                        this.counter.reset();
                    }
                    this.analyzeInvocation(data, methodCall);
                    lastBlock = currentBlock;
                    continue;
                }
                this.checkForViolation(data);
                this.counter.reset();
            }
            if (namedReference.getParent() instanceof ASTMethodCall) continue;
            this.checkForViolation(data);
            this.counter.reset();
        }
        this.checkForViolation(data);
        return data;
    }

    private void checkConstructor(Object data, ASTVariableDeclaratorId node) {
        ASTExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        ASTConstructorCall constructorCall = (ASTConstructorCall)initializer.descendantsOrSelf().filterIs(ASTConstructorCall.class).first();
        if (constructorCall == null) {
            return;
        }
        this.analyzeInvocation(data, constructorCall);
        Node parent = constructorCall.getParent();
        while (parent instanceof ASTMethodCall) {
            this.analyzeInvocation(data, (ASTMethodCall)parent);
            parent = parent.getParent();
        }
    }

    private void analyzeInvocation(Object data, InvocationNode invocation) {
        if (!(invocation instanceof ASTExpression)) {
            return;
        }
        if (!JavaRuleUtil.isStringBuilderCtorOrAppend((ASTExpression)((Object)invocation))) {
            return;
        }
        if (this.isAdditive(invocation)) {
            this.processAdditive(data, invocation);
        } else if (this.isAppendingVariablesOrFields(invocation) || this.isAppendingInvocationResult(invocation)) {
            this.checkForViolation(data);
            this.counter.reset();
        } else if (invocation.getArguments().getFirstChild() instanceof ASTStringLiteral || invocation instanceof ASTMethodCall) {
            this.counter.count((Node)invocation.getArguments().getFirstChild());
        }
    }

    private void processAdditive(Object data, InvocationNode invocation) {
        ASTExpression firstArg = (ASTExpression)invocation.getArguments().getFirstChild();
        if (firstArg.descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).count() > 0) {
            this.checkForViolation(data);
            if (firstArg instanceof ASTInfixExpression) {
                ASTExpression rightOperand = ((ASTInfixExpression)firstArg).getRightOperand();
                if (rightOperand instanceof ASTStringLiteral) {
                    this.counter.count((Node)rightOperand);
                }
            } else {
                this.counter.reset();
            }
        } else {
            this.counter.count((Node)invocation.getArguments().getFirstChild());
        }
    }

    private boolean isAdditive(InvocationNode n) {
        return JavaAstUtils.isStringConcatExpr(n.getArguments().getFirstChild());
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.getParent(); parentNode != null && !BLOCK_PARENTS.contains(parentNode.getClass()); parentNode = parentNode.getParent()) {
            lastNode = parentNode;
        }
        if (parentNode instanceof ASTIfStatement) {
            parentNode = lastNode;
        }
        return parentNode;
    }

    private void checkForViolation(Object data) {
        if (this.counter.isViolation()) {
            assert (this.counter.getReportNode() != null);
            Object[] param = new String[]{String.valueOf(this.counter.getCounter())};
            this.addViolation(data, this.counter.getReportNode(), param);
        }
    }

    private boolean isAppendingVariablesOrFields(InvocationNode node) {
        return node.getArguments().descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).count() > 0;
    }

    private boolean isAppendingInvocationResult(InvocationNode node) {
        return node.getArguments().getFirstChild() instanceof ASTMethodCall || node.getArguments().getFirstChild() instanceof ASTConstructorCall;
    }

    static boolean isStringBuilderOrBuffer(TypeNode node) {
        return TypeTestUtil.isA(StringBuffer.class, node) || TypeTestUtil.isA(StringBuilder.class, node);
    }

    static {
        BLOCK_PARENTS.add(ASTForStatement.class);
        BLOCK_PARENTS.add(ASTForeachStatement.class);
        BLOCK_PARENTS.add(ASTWhileStatement.class);
        BLOCK_PARENTS.add(ASTDoStatement.class);
        BLOCK_PARENTS.add(ASTIfStatement.class);
        BLOCK_PARENTS.add(ASTSwitchStatement.class);
        BLOCK_PARENTS.add(ASTMethodDeclaration.class);
        BLOCK_PARENTS.add(ASTCatchClause.class);
        BLOCK_PARENTS.add(ASTFinallyClause.class);
        BLOCK_PARENTS.add(ASTLambdaExpression.class);
        BLOCK_PARENTS.add(ASTSwitchArrowBranch.class);
        BLOCK_PARENTS.add(ASTSwitchFallthroughBranch.class);
        THRESHOLD_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"threshold").desc("Max consecutive appends")).require(NumericConstraints.inRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(10)))).defaultValue((Object)1)).build();
    }

    private static final class ConsecutiveCounter {
        private int threshold;
        private int counter;
        private Node reportNode;

        private ConsecutiveCounter() {
        }

        public void initThreshold(int threshold) {
            this.threshold = threshold;
        }

        public void count(Node node) {
            if (this.counter == 0) {
                this.reportNode = node;
            }
            ++this.counter;
        }

        public void reset() {
            this.counter = 0;
            this.reportNode = null;
        }

        public boolean isViolation() {
            return this.counter > this.threshold;
        }

        public int getCounter() {
            return this.counter;
        }

        public Node getReportNode() {
            return this.reportNode;
        }

        public String toString() {
            return "counter=" + this.counter + ",threshold=" + this.threshold + ",node=" + this.reportNode;
        }
    }
}

