/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.lang.reflect.Modifier;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JLocalVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DoubleCheckedLockingRule
extends AbstractJavaRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTMethodDeclaration.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        List assignments;
        ASTIfStatement is2;
        List ssl;
        ASTIfStatement outerIf;
        if (node.isVoid() || node.getResultTypeNode() instanceof ASTPrimitiveType || node.getBody() == null) {
            return data;
        }
        List rsl = node.descendants(ASTReturnStatement.class).toList();
        if (rsl.size() != 1) {
            return data;
        }
        ASTReturnStatement rs = (ASTReturnStatement)rsl.get(0);
        ASTExpression returnExpr = rs.getExpr();
        if (!(returnExpr instanceof ASTAssignableExpr.ASTNamedReferenceExpr)) {
            return data;
        }
        JVariableSymbol returnVariable = ((ASTAssignableExpr.ASTNamedReferenceExpr)returnExpr).getReferencedSym();
        if (returnVariable instanceof JFieldSymbol && Modifier.isVolatile(((JFieldSymbol)returnVariable).getModifiers())) {
            return data;
        }
        if (this.isLocalOnlyStoredWithVolatileField(node, returnVariable)) {
            return data;
        }
        List isl = node.findDescendantsOfType(ASTIfStatement.class);
        if (isl.size() == 2 && JavaRuleUtil.isNullCheck((outerIf = (ASTIfStatement)isl.get(0)).getCondition(), returnVariable) && (ssl = outerIf.findDescendantsOfType(ASTSynchronizedStatement.class)).size() == 1 && ((ASTSynchronizedStatement)ssl.get(0)).ancestors().any(it -> it == outerIf) && JavaRuleUtil.isNullCheck((is2 = (ASTIfStatement)isl.get(1)).getCondition(), returnVariable) && (assignments = is2.findDescendantsOfType(ASTAssignmentExpression.class)).size() == 1 && JavaAstUtils.isReferenceToVar((ASTExpression)((ASTAssignmentExpression)assignments.get(0)).getLeftOperand(), returnVariable)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean isLocalOnlyStoredWithVolatileField(ASTMethodDeclaration method, JVariableSymbol local) {
        ASTVariableDeclaratorId id;
        if (local instanceof JLocalVariableSymbol) {
            id = (ASTVariableDeclaratorId)local.tryGetNode();
            if (id == null) {
                return false;
            }
        } else {
            return false;
        }
        ASTExpression initializer = id.getInitializer();
        return (initializer == null || this.isVolatileFieldReference(initializer)) && method.descendants(ASTAssignmentExpression.class).filter(it -> JavaAstUtils.isReferenceToVar((ASTExpression)it.getLeftOperand(), local)).all(it -> this.isVolatileFieldReference(it.getRightOperand()));
    }

    private boolean isVolatileFieldReference(@Nullable ASTExpression initializer) {
        if (initializer instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            JVariableSymbol fieldSym = ((ASTAssignableExpr.ASTNamedReferenceExpr)initializer).getReferencedSym();
            return fieldSym instanceof JFieldSymbol && Modifier.isVolatile(((JFieldSymbol)fieldSym).getModifiers());
        }
        return false;
    }
}

