/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.internal.StablePathMatcher;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaRuleUtil {
    private static final InvocationMatcher.CompoundInvocationMatcher KNOWN_PURE_METHODS = InvocationMatcher.parseAll("_#toString()", "_#hashCode()", "_#equals(java.lang.Object)", "java.lang.String#_(_*)", "java.util.stream.Stream#_(_*)", "java.util.Collection#size()", "java.util.List#get(int)", "java.util.Map#get(_)", "java.lang.Iterable#iterator()", "java.lang.Comparable#compareTo(_)");
    public static final Set<String> LOMBOK_ANNOTATIONS = CollectionUtil.immutableSetOf((Object)"lombok.Data", (Object[])new String[]{"lombok.Getter", "lombok.Setter", "lombok.Value", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.NoArgsConstructor", "lombok.Builder", "lombok.EqualsAndHashCode", "lombok.experimental.Delegate"});

    private JavaRuleUtil() {
    }

    public static boolean isZeroChecked(ASTExpression e) {
        JavaNode parent = (JavaNode)e.getParent();
        if (parent instanceof ASTInfixExpression) {
            int expectedValue;
            BinaryOp op = ((ASTInfixExpression)parent).getOperator();
            int checkLiteralAtIdx = 1 - e.getIndexInParent();
            JavaNode comparand = (JavaNode)parent.getChild(checkLiteralAtIdx);
            if (op == BinaryOp.NE || op == BinaryOp.EQ) {
                expectedValue = 0;
            } else if (op == BinaryOp.LT || op == BinaryOp.GE) {
                expectedValue = checkLiteralAtIdx;
            } else if (op == BinaryOp.GT || op == BinaryOp.LE) {
                expectedValue = 1 - checkLiteralAtIdx;
            } else {
                return false;
            }
            return JavaAstUtils.isLiteralInt(comparand, expectedValue);
        }
        return false;
    }

    public static boolean isStringBuilderCtorOrAppend(@Nullable ASTExpression e) {
        if (e instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)e;
            if ("append".equals(call.getMethodName())) {
                ASTExpression qual = ((ASTMethodCall)e).getQualifier();
                return qual != null && JavaRuleUtil.isStringBufferOrBuilder(qual);
            }
        } else if (e instanceof ASTConstructorCall) {
            return JavaRuleUtil.isStringBufferOrBuilder(((ASTConstructorCall)e).getTypeNode());
        }
        return false;
    }

    private static boolean isStringBufferOrBuilder(TypeNode node) {
        return TypeTestUtil.isExactlyA(StringBuilder.class, node) || TypeTestUtil.isExactlyA(StringBuffer.class, node);
    }

    public static boolean isUtilityClass(ASTAnyTypeDeclaration node) {
        if (!node.isRegularClass()) {
            return false;
        }
        ASTClassOrInterfaceDeclaration classNode = (ASTClassOrInterfaceDeclaration)node;
        if (classNode.getSuperClassTypeNode() != null || !classNode.getSuperInterfaceTypeNodes().isEmpty()) {
            return false;
        }
        boolean hasAny = false;
        for (ASTBodyDeclaration declNode : classNode.getDeclarations()) {
            if (declNode instanceof ASTFieldDeclaration || declNode instanceof ASTMethodDeclaration) {
                boolean bl = hasAny = JavaRuleUtil.isNonPrivate(declNode) && !JavaAstUtils.isMainMethod(declNode);
                if (((AccessNode)((Object)declNode)).hasModifiers(JModifier.STATIC, new JModifier[0])) continue;
                return false;
            }
            if (!(declNode instanceof ASTInitializer) || ((ASTInitializer)declNode).isStatic()) continue;
            return false;
        }
        return hasAny;
    }

    private static boolean isNonPrivate(ASTBodyDeclaration decl) {
        return ((AccessNode)((Object)decl)).getVisibility() != AccessNode.Visibility.V_PRIVATE;
    }

    public static boolean isExplicitUnusedVarName(String name) {
        return name.startsWith("ignored") || name.startsWith("unused") || "_".equals(name);
    }

    public static boolean startsWithCamelCaseWord(String camelCaseString, String prefixWord) {
        return camelCaseString.startsWith(prefixWord) && camelCaseString.length() > prefixWord.length() && Character.isUpperCase(camelCaseString.charAt(prefixWord.length()));
    }

    public static boolean containsCamelCaseWord(String camelCaseString, String capitalizedWord) {
        assert (capitalizedWord.length() > 0 && Character.isUpperCase(capitalizedWord.charAt(0))) : "Not a capitalized string \"" + capitalizedWord + "\"";
        int index = camelCaseString.indexOf(capitalizedWord);
        if (index >= 0 && camelCaseString.length() > index + capitalizedWord.length()) {
            return Character.isUpperCase(camelCaseString.charAt(index + capitalizedWord.length()));
        }
        return index >= 0 && camelCaseString.length() == index + capitalizedWord.length();
    }

    public static boolean isGetterOrSetterCall(ASTMethodCall call) {
        return JavaRuleUtil.isGetterCall(call) || JavaRuleUtil.isSetterCall(call);
    }

    private static boolean isSetterCall(ASTMethodCall call) {
        return call.getArguments().size() > 0 && JavaRuleUtil.startsWithCamelCaseWord(call.getMethodName(), "set");
    }

    public static boolean isGetterCall(ASTMethodCall call) {
        return call.getArguments().size() == 0 && (JavaRuleUtil.startsWithCamelCaseWord(call.getMethodName(), "get") || JavaRuleUtil.startsWithCamelCaseWord(call.getMethodName(), "is"));
    }

    public static boolean isGetterOrSetter(ASTMethodDeclaration node) {
        return JavaRuleUtil.isGetter(node) || JavaRuleUtil.isSetter(node);
    }

    private static boolean isGetter(ASTMethodDeclaration node) {
        if (node.getArity() != 0 || node.isVoid()) {
            return false;
        }
        ASTAnyTypeDeclaration enclosing = node.getEnclosingType();
        if (JavaRuleUtil.startsWithCamelCaseWord(node.getName(), "get")) {
            return JavaAstUtils.hasField(enclosing, node.getName().substring(3));
        }
        if (JavaRuleUtil.startsWithCamelCaseWord(node.getName(), "is") && TypeTestUtil.isA(Boolean.TYPE, (TypeNode)node.getResultTypeNode())) {
            return JavaAstUtils.hasField(enclosing, node.getName().substring(2));
        }
        return JavaAstUtils.hasField(enclosing, node.getName());
    }

    private static boolean isSetter(ASTMethodDeclaration node) {
        if (node.getArity() != 1 || !node.isVoid()) {
            return false;
        }
        ASTAnyTypeDeclaration enclosing = node.getEnclosingType();
        if (JavaRuleUtil.startsWithCamelCaseWord(node.getName(), "set")) {
            return JavaAstUtils.hasField(enclosing, node.getName().substring(3));
        }
        return JavaAstUtils.hasField(enclosing, node.getName());
    }

    public static boolean isSerialPersistentFields(ASTFieldDeclaration field) {
        return field.hasModifiers(JModifier.FINAL, new JModifier[]{JModifier.STATIC, JModifier.PRIVATE}) && field.getVarIds().any(it -> "serialPersistentFields".equals(it.getName()) && TypeTestUtil.isA(ObjectStreamField[].class, (TypeNode)it));
    }

    public static boolean isSerialVersionUID(ASTFieldDeclaration field) {
        return field.hasModifiers(JModifier.FINAL, new JModifier[]{JModifier.STATIC}) && field.getVarIds().any(it -> "serialVersionUID".equals(it.getName()) && it.getTypeMirror().isPrimitive(JPrimitiveType.PrimitiveTypeKind.LONG));
    }

    public static boolean isSerializationReadObject(ASTMethodDeclaration node) {
        return node.getVisibility() == AccessNode.Visibility.V_PRIVATE && "readObject".equals(node.getName()) && JavaAstUtils.hasExceptionList(node, InvalidObjectException.class) && JavaAstUtils.hasParameters(node, ObjectInputStream.class);
    }

    public static boolean hasSideEffect(@Nullable JavaNode node, Set<? extends JVariableSymbol> localVarsToTrack) {
        return node != null && node.descendantsOrSelf().filterIs(ASTExpression.class).any(e -> JavaRuleUtil.hasSideEffectNonRecursive(e, localVarsToTrack));
    }

    private static boolean hasSideEffectNonRecursive(ASTExpression e, Set<? extends JVariableSymbol> localVarsToTrack) {
        if (e instanceof ASTAssignmentExpression) {
            ASTAssignableExpr lhs = ((ASTAssignmentExpression)e).getLeftOperand();
            return JavaRuleUtil.isNonLocalLhs(lhs) || JavaAstUtils.isReferenceToVar((ASTExpression)lhs, localVarsToTrack);
        }
        if (e instanceof ASTUnaryExpression) {
            ASTUnaryExpression unary = (ASTUnaryExpression)e;
            ASTExpression lhs = unary.getOperand();
            return !unary.getOperator().isPure() && (JavaRuleUtil.isNonLocalLhs(lhs) || JavaAstUtils.isReferenceToVar(lhs, localVarsToTrack));
        }
        return e.ancestors(ASTThrowStatement.class).isEmpty() && (e instanceof ASTMethodCall && !JavaRuleUtil.isPure((ASTMethodCall)e) || e instanceof ASTConstructorCall);
    }

    private static boolean isNonLocalLhs(ASTExpression lhs) {
        return lhs instanceof ASTArrayAccess || !JavaAstUtils.isReferenceToLocal(lhs);
    }

    private static boolean isPure(ASTMethodCall call) {
        return JavaRuleUtil.isGetterCall(call) || KNOWN_PURE_METHODS.anyMatch(call);
    }

    public static @Nullable ASTVariableDeclaratorId getReferencedNode(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
        JVariableSymbol referencedSym = expr.getReferencedSym();
        return referencedSym == null ? null : (ASTVariableDeclaratorId)referencedSym.tryGetNode();
    }

    public static boolean hasLombokAnnotation(Annotatable node) {
        return LOMBOK_ANNOTATIONS.stream().anyMatch(node::isAnnotationPresent);
    }

    public static boolean isNullCheck(ASTExpression expr, JVariableSymbol var) {
        return JavaRuleUtil.isNullCheck(expr, StablePathMatcher.matching(var));
    }

    public static boolean isNullCheck(ASTExpression expr, StablePathMatcher matcher) {
        ASTNullLiteral nullLit;
        ASTInfixExpression condition;
        if (expr instanceof ASTInfixExpression && (condition = (ASTInfixExpression)expr).getOperator().hasSamePrecedenceAs(BinaryOp.EQ) && (nullLit = (ASTNullLiteral)condition.firstChild(ASTNullLiteral.class)) != null) {
            return matcher.matches(JavaAstUtils.getOtherOperandIfInInfixExpr(nullLit));
        }
        return false;
    }

    public static boolean isNullChecked(ASTExpression expr) {
        ASTInfixExpression infx;
        if (expr.getParent() instanceof ASTInfixExpression && (infx = (ASTInfixExpression)expr.getParent()).getOperator().hasSamePrecedenceAs(BinaryOp.EQ)) {
            return JavaAstUtils.getOtherOperandIfInInfixExpr(expr) instanceof ASTNullLiteral;
        }
        return false;
    }
}

