/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class SingletonClassReturningNewInstanceRule
extends AbstractJavaRulechainRule {
    public SingletonClassReturningNewInstanceRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isVoid() || !"getInstance".equals(node.getName())) {
            return data;
        }
        NodeStream.DescendantNodeStream rsl = node.descendants(ASTReturnStatement.class);
        if (this.returnsNewInstances((NodeStream<ASTReturnStatement>)rsl) || this.returnsLocalVariables((NodeStream<ASTReturnStatement>)rsl)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean returnsNewInstances(NodeStream<ASTReturnStatement> returns) {
        return returns.descendants(ASTConstructorCall.class).nonEmpty();
    }

    private boolean returnsLocalVariables(NodeStream<ASTReturnStatement> returns) {
        return returns.children(ASTVariableAccess.class).filter(JavaAstUtils::isReferenceToLocal).nonEmpty();
    }
}

