/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTThrowsList;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class SignatureDeclareThrowsExceptionRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_JUNIT_COMPLETELY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"IgnoreJUnitCompletely").defaultValue((Object)false)).desc("Allow all methods in a JUnit3 TestCase to throw Exceptions")).build();

    public SignatureDeclareThrowsExceptionRule() {
        super(ASTThrowsList.class, new Class[0]);
        this.definePropertyDescriptor(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTThrowsList throwsList, Object o) {
        if (!this.isIgnored(throwsList.getOwner()) && throwsList.toStream().any(it -> TypeTestUtil.isExactlyA(Exception.class, (TypeNode)it))) {
            this.addViolation(o, (Node)throwsList);
        }
        return null;
    }

    private boolean isIgnored(ASTMethodOrConstructorDeclaration owner) {
        if (((Boolean)this.getProperty(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR)).booleanValue() && TestFrameworksUtil.isJUnit3Class(owner.getEnclosingType())) {
            return true;
        }
        if (owner instanceof ASTMethodDeclaration) {
            ASTMethodDeclaration m = (ASTMethodDeclaration)owner;
            return TestFrameworksUtil.isTestMethod(m) || TestFrameworksUtil.isTestConfigurationMethod(m) || m.isOverridden();
        }
        return false;
    }
}

