/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractJavaRule {
    private int depth;
    private int depthLimit;
    private static final PropertyDescriptor<Integer> PROBLEM_DEPTH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"problemDepth").desc("The if statement depth reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)3)).build();

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor(PROBLEM_DEPTH_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.depth = 0;
        this.depthLimit = (Integer)this.getProperty(PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (!node.hasElse()) {
            ++this.depth;
        }
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, (Node)node);
        }
        --this.depth;
        return data;
    }
}

