/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;

public class AtLeastOneConstructorRule
extends AbstractIgnoredAnnotationRule {
    public AtLeastOneConstructorRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Arrays.asList("lombok.Data", "lombok.Value", "lombok.Builder", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor");
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isRegularClass() || node.isStatic() || node.getDeclarations().any(it -> it instanceof ASTConstructorDeclaration) || this.hasIgnoredAnnotation(node)) {
            return data;
        }
        NodeStream members = node.getDeclarations().filterIs(AccessNode.class).filterNot(it -> it instanceof ASTAnyTypeDeclaration);
        if (members.isEmpty() || members.any(it -> !it.isStatic())) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }
}

