/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class AvoidReassigningParametersRule
extends AbstractJavaRulechainRule {
    public AvoidReassigningParametersRule() {
        super(ASTMethodDeclaration.class, ASTConstructorDeclaration.class);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.lookForViolations(node, data);
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.lookForViolations(node, data);
        return data;
    }

    private void lookForViolations(ASTMethodOrConstructorDeclaration node, Object data) {
        block0: for (ASTFormalParameter formal : node.getFormalParameters()) {
            ASTVariableDeclaratorId varId = formal.getVarId();
            for (ASTAssignableExpr.ASTNamedReferenceExpr usage : varId.getLocalUsages()) {
                if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE) continue;
                this.addViolation(data, (Node)usage, varId.getName());
                continue block0;
            }
        }
    }
}

