/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.bestpractices.AccessorMethodGenerationRule;

public class AccessorClassGenerationRule
extends AbstractJavaRulechainRule {
    private final Set<JavaNode> reportedNodes = new HashSet<JavaNode>();

    public AccessorClassGenerationRule() {
        super(ASTConstructorCall.class, ASTExplicitConstructorInvocation.class);
    }

    public void end(RuleContext ctx) {
        super.end(ctx);
        this.reportedNodes.clear();
    }

    @Override
    public Object visit(ASTConstructorCall node, Object data) {
        if (!node.isAnonymousClass()) {
            AccessorMethodGenerationRule.checkMemberAccess(this, (RuleContext)data, node, node.getMethodType().getSymbol(), this.reportedNodes);
        }
        return null;
    }

    @Override
    public Object visit(ASTExplicitConstructorInvocation node, Object data) {
        if (node.isSuper()) {
            AccessorMethodGenerationRule.checkMemberAccess(this, (RuleContext)data, node, node.getMethodType().getSymbol(), this.reportedNodes);
        }
        return null;
    }
}

