/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.InternalInterfaces;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum UnaryOp implements InternalInterfaces.OperatorLike
{
    UNARY_PLUS("+"),
    UNARY_MINUS("-"),
    COMPLEMENT("~"),
    NEGATION("!"),
    PRE_INCREMENT("++"),
    PRE_DECREMENT("--"),
    POST_INCREMENT("++"),
    POST_DECREMENT("--");

    private final String code;

    private UnaryOp(String code) {
        this.code = code;
    }

    public boolean isPure() {
        return this.ordinal() < PRE_INCREMENT.ordinal();
    }

    public boolean isIncrement() {
        return this == PRE_INCREMENT || this == POST_INCREMENT;
    }

    public boolean isDecrement() {
        return this == PRE_DECREMENT || this == POST_DECREMENT;
    }

    public boolean isPrefix() {
        return this.ordinal() < POST_INCREMENT.ordinal();
    }

    public boolean isPostfix() {
        return !this.isPrefix();
    }

    @Override
    public String getToken() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public static boolean isUnaryExprWithOperator(@Nullable JavaNode e, Set<UnaryOp> operators) {
        if (e instanceof ASTUnaryExpression) {
            ASTUnaryExpression unary = (ASTUnaryExpression)e;
            return operators.contains(unary.getOperator());
        }
        return false;
    }

    public static boolean isUnaryExprWithOperator(@Nullable JavaNode e, UnaryOp operator) {
        if (e instanceof ASTUnaryExpression) {
            ASTUnaryExpression unary = (ASTUnaryExpression)e;
            return operator == unary.getOperator();
        }
        return false;
    }
}

