/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SuperTypesEnumerator;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.TypeOps;

final class OverrideResolutionPass {
    private OverrideResolutionPass() {
    }

    static void resolveOverrides(ASTAnyTypeDeclaration node) {
        RelevantMethodSet relevantMethods = new RelevantMethodSet(node.getTypeMirror());
        for (ASTMethodDeclaration methodDecl : node.getDeclarations(ASTMethodDeclaration.class)) {
            relevantMethods.addIfRelevant(methodDecl);
        }
        if (relevantMethods.tracked.isEmpty()) {
            return;
        }
        SuperTypesEnumerator.ALL_STRICT_SUPERTYPES.stream(node.getTypeMirror()).flatMap(st -> st.streamDeclaredMethods(relevantMethods::isRelevant)).forEach(relevantMethods::findMethodOverridingThisSig);
    }

    private static final class RelevantMethodSet {
        private final Map<String, BitSet> map = new HashMap<String, BitSet>();
        private final Set<ASTMethodDeclaration> tracked = new LinkedHashSet<ASTMethodDeclaration>();
        private final JClassType site;

        private RelevantMethodSet(JClassType site) {
            this.site = site;
        }

        void addIfRelevant(ASTMethodDeclaration m) {
            if (m.getModifiers().hasAny(JModifier.STATIC, JModifier.PRIVATE)) {
                return;
            }
            if (m.isAnnotationPresent(Override.class)) {
                m.setOverriddenMethod(m.getTypeSystem().UNRESOLVED_METHOD);
            }
            BitSet aritySet = this.map.computeIfAbsent(m.getName(), n -> new BitSet(m.getArity() + 1));
            aritySet.set(m.getArity());
            this.tracked.add(m);
        }

        boolean isRelevant(JMethodSymbol superMethod) {
            if (!TypeOps.isOverridableIn(superMethod, (JTypeDeclSymbol)this.site.getSymbol())) {
                return false;
            }
            BitSet aritySet = this.map.get(superMethod.getSimpleName());
            return aritySet != null && aritySet.get(superMethod.getArity());
        }

        void findMethodOverridingThisSig(JMethodSig superSig) {
            ASTMethodDeclaration subSig = null;
            for (ASTMethodDeclaration it : this.tracked) {
                if (!TypeOps.isSubSignature(it.getGenericSignature(), superSig)) continue;
                subSig = it;
                break;
            }
            if (subSig != null) {
                subSig.setOverriddenMethod(superSig);
                this.tracked.remove(subSig);
            }
        }
    }
}

