/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.AstImplUtil;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTResource
extends AbstractJavaNode {
    ASTResource(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public boolean isConciseResource() {
        return this.getChild(0) instanceof ASTExpression;
    }

    public String getStableName() {
        if (this.isConciseResource()) {
            ASTExpression expr = this.getInitializer();
            StringBuilder builder = new StringBuilder();
            while (expr instanceof ASTFieldAccess) {
                ASTFieldAccess fa = (ASTFieldAccess)expr;
                builder.insert(0, "." + fa.getName());
                expr = fa.getQualifier();
            }
            if (expr != null) {
                builder.insert(0, expr.getImage());
            }
            return builder.toString();
        }
        return ((ASTVariableDeclaratorId)this.asLocalVariableDeclaration().iterator().next()).getName();
    }

    public @Nullable ASTLocalVariableDeclaration asLocalVariableDeclaration() {
        return AstImplUtil.getChildAs(this, 0, ASTLocalVariableDeclaration.class);
    }

    public ASTExpression getInitializer() {
        Node c = this.getChild(0);
        if (c instanceof ASTExpression) {
            return (ASTExpression)c;
        }
        return ((ASTVariableDeclaratorId)((ASTLocalVariableDeclaration)c).iterator().next()).getInitializer();
    }
}

