/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Iterator;
import net.sourceforge.pmd.annotation.DeprecatedUntil700;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationMemberList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValue;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValueArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.JClassType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTAnnotation
extends AbstractJavaTypeNode
implements TypeNode,
ASTMemberValue,
Iterable<ASTMemberValuePair> {
    ASTAnnotation(int id) {
        super(id);
    }

    public ASTClassOrInterfaceType getTypeNode() {
        return (ASTClassOrInterfaceType)this.getChild(0);
    }

    @Override
    public @NonNull JClassType getTypeMirror() {
        return (JClassType)super.getTypeMirror();
    }

    @Deprecated
    @DeprecatedUntil700
    public String getAnnotationName() {
        return this.getTypeNode().getText().toString();
    }

    public String getSimpleName() {
        return this.getTypeNode().getSimpleName();
    }

    public @Nullable ASTAnnotationMemberList getMemberList() {
        return (ASTAnnotationMemberList)this.children().first(ASTAnnotationMemberList.class);
    }

    public NodeStream<ASTMemberValuePair> getMembers() {
        return this.children(ASTAnnotationMemberList.class).children(ASTMemberValuePair.class);
    }

    @Override
    public Iterator<ASTMemberValuePair> iterator() {
        return this.children(ASTMemberValuePair.class).iterator();
    }

    public NodeStream<ASTMemberValue> getFlatValue(String attrName) {
        return NodeStream.of((Node)this.getAttribute(attrName)).flatMap(v -> v instanceof ASTMemberValueArrayInitializer ? v.children(ASTMemberValue.class) : NodeStream.of((Node)v));
    }

    public @Nullable ASTMemberValue getAttribute(String attrName) {
        return (ASTMemberValue)this.getMembers().filter(pair -> pair.getName().equals(attrName)).map(ASTMemberValuePair::getValue).first();
    }

    @Override
    public <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }
}

