/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class VariableNameDeclaration
extends AbstractNameDeclaration
implements TypedNameDeclaration {
    public VariableNameDeclaration(ASTVariableDeclaratorId node) {
        super((ScopedNode)node);
    }

    public Scope getScope() {
        return this.node.getScope().getEnclosingScope(ClassScope.class);
    }

    public boolean isArray() {
        ASTVariableDeclaratorId astVariableDeclaratorId = (ASTVariableDeclaratorId)this.node;
        ASTType typeNode = astVariableDeclaratorId.getTypeNode();
        if (typeNode != null) {
            return ((Dimensionable)typeNode.getParent()).isArray();
        }
        return false;
    }

    public int getArrayDepth() {
        ASTVariableDeclaratorId astVariableDeclaratorId = (ASTVariableDeclaratorId)this.node;
        ASTType typeNode = astVariableDeclaratorId.getTypeNode();
        if (typeNode != null) {
            return ((Dimensionable)typeNode.getParent()).getArrayDepth();
        }
        return 0;
    }

    public boolean isVarargs() {
        ASTVariableDeclaratorId astVariableDeclaratorId = (ASTVariableDeclaratorId)this.node;
        ASTFormalParameter parameter = (ASTFormalParameter)astVariableDeclaratorId.getFirstParentOfType(ASTFormalParameter.class);
        return parameter != null && parameter.isVarargs();
    }

    public boolean isExceptionBlockParameter() {
        return this.getDeclaratorId().isExceptionBlockParameter();
    }

    @Deprecated
    public boolean isLambdaTypelessParameter() {
        return this.isTypeInferred();
    }

    public boolean isTypeInferred() {
        return this.getDeclaratorId().isTypeInferred();
    }

    public boolean isPrimitiveType() {
        return !this.isTypeInferred() && ((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).getChild(0) instanceof ASTPrimitiveType;
    }

    @Override
    public String getTypeImage() {
        TypeNode typeNode = this.getExplicitTypeNode();
        if (typeNode != null) {
            return typeNode.getImage();
        }
        return null;
    }

    public boolean isReferenceType() {
        return !this.isTypeInferred() && ((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).getChild(0) instanceof ASTReferenceType;
    }

    public boolean isRecordComponent() {
        return this.node.getParent() instanceof ASTRecordComponent;
    }

    public AccessNode getAccessNodeParent() {
        if (this.isRecordComponent()) {
            return null;
        }
        if (this.node.getParent() instanceof ASTFormalParameter || this.node.getParent() instanceof ASTLambdaExpression) {
            return (AccessNode)this.node.getParent();
        }
        return (AccessNode)this.node.getParent().getParent();
    }

    public ASTVariableDeclaratorId getDeclaratorId() {
        return (ASTVariableDeclaratorId)this.node;
    }

    @Override
    public TypeNode getTypeNode() {
        return this.getDeclaratorId();
    }

    private TypeNode getExplicitTypeNode() {
        if (this.isRecordComponent()) {
            return (TypeNode)((ASTType)this.node.getParent().getFirstChildOfType(ASTType.class)).getChild(0);
        }
        if (this.isPrimitiveType()) {
            return (TypeNode)((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).getChild(0);
        }
        if (!this.isTypeInferred()) {
            return (TypeNode)((JavaNode)((ASTType)this.getAccessNodeParent().getFirstChildOfType(ASTType.class)).getChild(0)).getChild(0);
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        TypeNode typeNode = this.getExplicitTypeNode();
        if (typeNode != null) {
            return typeNode.getType();
        }
        return this.getDeclaratorId().getType();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableNameDeclaration)) {
            return false;
        }
        VariableNameDeclaration n = (VariableNameDeclaration)o;
        return n.node.getImage().equals(this.node.getImage());
    }

    public int hashCode() {
        return this.node.getImage().hashCode();
    }

    public String toString() {
        return "Variable: image = '" + this.node.getImage() + "', line = " + this.node.getBeginLine();
    }
}

