/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class InvalidJavaBeanRule
extends AbstractJavaRule {
    private static final String LOMBOK_DATA = "lombok.Data";
    private static final String LOMBOK_GETTER = "lombok.Getter";
    private static final String LOMBOK_SETTER = "lombok.Setter";
    private static final PropertyDescriptor<Boolean> ENSURE_SERIALIZATION = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ensureSerialization").desc("Require that beans implement java.io.Serializable.")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<List<String>> PACKAGES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"packages").desc("Consider classes in only these package to be beans. Set to an empty value to check all classes.")).defaultValues((Object)"org.example.beans", (Object[])new String[0]).delim(',').build();
    private Map<String, PropertyInfo> properties;

    public InvalidJavaBeanRule() {
        this.definePropertyDescriptor(ENSURE_SERIALIZATION);
        this.definePropertyDescriptor(PACKAGES_DESCRIPTOR);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        List packages;
        String packageName = "";
        ASTPackageDeclaration packageDeclaration = node.getRoot().getPackageDeclaration();
        if (packageDeclaration != null) {
            packageName = packageDeclaration.getName();
        }
        if (!(packages = (List)this.getProperty(PACKAGES_DESCRIPTOR)).isEmpty() && !packages.contains(packageName)) {
            return null;
        }
        String beanName = node.getSimpleName();
        if (((Boolean)this.getProperty(ENSURE_SERIALIZATION)).booleanValue() && !TypeTestUtil.isA(Serializable.class, (TypeNode)node)) {
            this.asCtx(data).addViolationWithMessage((Node)node, "The bean ''{0}'' does not implement java.io.Serializable.", new Object[]{beanName});
        }
        if (!this.hasNoArgConstructor(node)) {
            this.asCtx(data).addViolationWithMessage((Node)node, "The bean ''{0}'' is missing a no-arg constructor.", new Object[]{beanName});
        }
        if (this.hasClassLevelLombokDataAnnotation(node)) {
            return null;
        }
        this.properties = new HashMap<String, PropertyInfo>();
        this.collectFields(node);
        this.collectMethods(node);
        for (PropertyInfo propertyInfo : this.properties.values()) {
            if (!this.hasClassLevelLombokGetterAnnotation(node) && !this.hasClassLevelLombokSetterAnnotation(node) && propertyInfo.hasMissingGetter() && propertyInfo.hasMissingSetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getDeclaratorId(), "The bean ''{0}'' is missing a getter and a setter for property ''{1}''.", new Object[]{beanName, propertyInfo.getName()});
            } else if (!this.hasClassLevelLombokGetterAnnotation(node) && propertyInfo.hasMissingGetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getDeclaratorId(), "The bean ''{0}'' is missing a getter for property ''{1}''.", new Object[]{beanName, propertyInfo.getName()});
            } else if (!this.hasClassLevelLombokSetterAnnotation(node) && propertyInfo.hasMissingSetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getDeclaratorId(), "The bean ''{0}'' is missing a setter for property ''{1}''.", new Object[]{beanName, propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongGetterType()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getGetter(), "The bean ''{0}'' should return a ''{1}'' in getter of property ''{2}''.", new Object[]{beanName, propertyInfo.getTypeName(), propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongBooleanGetterName()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getGetter(), "The bean ''{0}'' should use the method name ''is{1}'' for the getter of property ''{2}''.", new Object[]{beanName, propertyInfo.getName(), propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongTypeGetterAndSetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getGetter(), "The bean ''{0}'' has a property ''{1}'' with getter and setter that don''t have the same type.", new Object[]{beanName, propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongIndexedGetterType()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.indexedGetter, "The bean ''{0}'' has a property ''{1}'' with an indexed getter using the wrong type.", new Object[]{beanName, propertyInfo.getName()});
            }
            if (!propertyInfo.hasWrongIndexedSetterType()) continue;
            this.asCtx(data).addViolationWithMessage((Node)propertyInfo.indexedSetter, "The bean ''{0}'' has a property ''{1}'' with an indexed setter using the wrong type.", new Object[]{beanName, propertyInfo.getName()});
        }
        return null;
    }

    private void collectFields(ASTClassOrInterfaceDeclaration node) {
        Map declarations = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (VariableNameDeclaration declaration : declarations.keySet()) {
            ASTFieldDeclaration fieldDeclaration;
            String propertyName = StringUtils.capitalize((String)declaration.getName());
            if (!(declaration.getAccessNodeParent() instanceof ASTFieldDeclaration) || (fieldDeclaration = (ASTFieldDeclaration)declaration.getAccessNodeParent()).isStatic() || fieldDeclaration.isTransient()) continue;
            PropertyInfo field = this.getOrCreatePropertyInfo(propertyName);
            field.setDeclaratorId(declaration.getDeclaratorId());
            field.setReadonly(fieldDeclaration.isFinal());
        }
    }

    private PropertyInfo getOrCreatePropertyInfo(String propertyName) {
        PropertyInfo propertyInfo = this.properties.get(propertyName);
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo(propertyName);
            this.properties.put(propertyName, propertyInfo);
        }
        return propertyInfo;
    }

    private void collectMethods(ASTClassOrInterfaceDeclaration node) {
        Map declarations = node.getScope().getDeclarations(MethodNameDeclaration.class);
        for (MethodNameDeclaration declaration : declarations.keySet()) {
            PropertyInfo propertyInfo;
            ASTMethodDeclaration methodDeclaration = declaration.getMethodNameDeclaratorNode().getParent();
            String methodName = declaration.getName();
            int parameterCount = declaration.getParameterCount();
            String propertyName = StringUtil.withoutPrefixes((String)methodName, (String[])new String[]{"get", "set", "is"});
            if (methodName.startsWith("get") || methodName.startsWith("is")) {
                if (parameterCount == 0) {
                    propertyInfo = this.getOrCreatePropertyInfo(propertyName);
                    propertyInfo.setGetter(methodDeclaration);
                    continue;
                }
                if (parameterCount != 1 || InvalidJavaBeanRule.getFirstParameterType(methodDeclaration) != Integer.TYPE) continue;
                propertyInfo = this.getOrCreatePropertyInfo(propertyName);
                propertyInfo.setIndexedGetter(methodDeclaration);
                continue;
            }
            if (!methodName.startsWith("set")) continue;
            if (parameterCount == 1) {
                propertyInfo = this.getOrCreatePropertyInfo(propertyName);
                propertyInfo.setSetter(methodDeclaration);
                continue;
            }
            if (parameterCount != 2 || InvalidJavaBeanRule.getFirstParameterType(methodDeclaration) != Integer.TYPE) continue;
            propertyInfo = this.getOrCreatePropertyInfo(propertyName);
            propertyInfo.setIndexedSetter(methodDeclaration);
        }
    }

    private static Class<?> getFirstParameterType(ASTMethodDeclaration declaration) {
        return InvalidJavaBeanRule.getParameterType(declaration, 0);
    }

    private static Class<?> getParameterType(ASTMethodDeclaration declaration, int i) {
        if (declaration.getArity() >= i + 1) {
            ASTFormalParameter firstParameter = (ASTFormalParameter)declaration.getFormalParameters().findChildrenOfType(ASTFormalParameter.class).get(i);
            return firstParameter.getType();
        }
        return null;
    }

    private static Class<?> getResultType(ASTMethodDeclaration declaration) {
        ASTResultType resultType = declaration.getResultType();
        if (resultType.isVoid()) {
            return Void.class;
        }
        return ((ASTType)resultType.getFirstChildOfType(ASTType.class)).getType();
    }

    private boolean hasNoArgConstructor(ASTClassOrInterfaceDeclaration node) {
        int constructorCount = 0;
        for (ASTAnyTypeBodyDeclaration declaration : node.getDeclarations()) {
            if (ASTAnyTypeBodyDeclaration.DeclarationKind.CONSTRUCTOR != declaration.getKind()) continue;
            ASTConstructorDeclaration ctor = (ASTConstructorDeclaration)declaration.getFirstChildOfType(ASTConstructorDeclaration.class);
            if (ctor.getArity() == 0) {
                return true;
            }
            ++constructorCount;
        }
        return constructorCount == 0;
    }

    private boolean hasClassLevelLombokDataAnnotation(ASTClassOrInterfaceDeclaration node) {
        return node.isAnnotationPresent(LOMBOK_DATA);
    }

    private boolean hasClassLevelLombokGetterAnnotation(ASTClassOrInterfaceDeclaration node) {
        return node.isAnnotationPresent(LOMBOK_GETTER);
    }

    private boolean hasClassLevelLombokSetterAnnotation(ASTClassOrInterfaceDeclaration node) {
        return node.isAnnotationPresent(LOMBOK_SETTER);
    }

    private static class PropertyInfo {
        private final String name;
        private ASTVariableDeclaratorId declaratorId;
        private boolean readonly;
        private ASTMethodDeclaration getter;
        private ASTMethodDeclaration indexedGetter;
        private ASTMethodDeclaration setter;
        private ASTMethodDeclaration indexedSetter;

        PropertyInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ASTVariableDeclaratorId getDeclaratorId() {
            return this.declaratorId;
        }

        public void setDeclaratorId(ASTVariableDeclaratorId declaratorId) {
            this.declaratorId = declaratorId;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public ASTMethodDeclaration getGetter() {
            return this.getter;
        }

        public void setGetter(ASTMethodDeclaration getter) {
            this.getter = getter;
        }

        public ASTMethodDeclaration getIndexedGetter() {
            return this.indexedGetter;
        }

        public void setIndexedGetter(ASTMethodDeclaration indexedGetter) {
            this.indexedGetter = indexedGetter;
        }

        public ASTMethodDeclaration getSetter() {
            return this.setter;
        }

        public void setSetter(ASTMethodDeclaration setter) {
            this.setter = setter;
        }

        public ASTMethodDeclaration getIndexedSetter() {
            return this.indexedSetter;
        }

        public void setIndexedSetter(ASTMethodDeclaration indexedSetter) {
            this.indexedSetter = indexedSetter;
        }

        private boolean hasMissingGetter() {
            return this.declaratorId != null && this.getter == null && !this.hasFieldLombokGetter();
        }

        private boolean hasMissingSetter() {
            return this.declaratorId != null && !this.readonly && this.setter == null && !this.hasFieldLombokSetter();
        }

        private String getTypeName() {
            Class type = null;
            if (this.declaratorId != null && this.declaratorId.getType() != null) {
                type = this.declaratorId.getType();
            } else if (this.getter != null) {
                type = InvalidJavaBeanRule.getResultType(this.getter);
            } else if (this.setter != null) {
                type = InvalidJavaBeanRule.getFirstParameterType(this.setter);
            }
            if (type != null) {
                if (type.isArray()) {
                    return type.getComponentType().getName() + "[]";
                }
                return type.getName();
            }
            return "<unknown type>";
        }

        private boolean hasWrongGetterType() {
            return this.declaratorId != null && this.declaratorId.getType() != null && this.getter != null && !this.getter.getResultType().isVoid() && this.declaratorId.getType() != InvalidJavaBeanRule.getResultType(this.getter);
        }

        private boolean hasWrongBooleanGetterName() {
            if (this.getter != null && (TypeTestUtil.isA(Boolean.class, (TypeNode)this.declaratorId) || TypeTestUtil.isA(Boolean.TYPE, (TypeNode)this.declaratorId))) {
                return !this.getter.getName().startsWith("is");
            }
            return false;
        }

        private boolean hasWrongTypeGetterAndSetter() {
            if (this.declaratorId != null || this.getter == null || this.setter == null) {
                return false;
            }
            Class parameterType = InvalidJavaBeanRule.getFirstParameterType(this.setter);
            return this.getter.getResultType().isVoid() || InvalidJavaBeanRule.getResultType(this.getter) != parameterType;
        }

        private boolean hasWrongIndexedGetterType() {
            Class getterType;
            if (this.getter == null || this.indexedGetter == null) {
                return false;
            }
            Class<?> propertyType = InvalidJavaBeanRule.getResultType(this.getter);
            if (propertyType != null && propertyType.isArray()) {
                propertyType = propertyType.getComponentType();
            }
            return propertyType != (getterType = InvalidJavaBeanRule.getResultType(this.indexedGetter));
        }

        private boolean hasWrongIndexedSetterType() {
            Class setterType;
            if (this.setter == null || this.indexedSetter == null) {
                return false;
            }
            Class<?> propertyType = InvalidJavaBeanRule.getFirstParameterType(this.setter);
            if (propertyType != null && propertyType.isArray()) {
                propertyType = propertyType.getComponentType();
            }
            return propertyType != (setterType = InvalidJavaBeanRule.getParameterType(this.indexedSetter, 1));
        }

        private boolean hasFieldLombokGetter() {
            ASTFieldDeclaration fieldDeclaration;
            ASTFieldDeclaration aSTFieldDeclaration = fieldDeclaration = this.declaratorId != null ? (ASTFieldDeclaration)this.declaratorId.getFirstParentOfType(ASTFieldDeclaration.class) : null;
            if (fieldDeclaration != null) {
                return fieldDeclaration.isAnnotationPresent(InvalidJavaBeanRule.LOMBOK_GETTER);
            }
            return false;
        }

        private boolean hasFieldLombokSetter() {
            ASTFieldDeclaration fieldDeclaration;
            ASTFieldDeclaration aSTFieldDeclaration = fieldDeclaration = this.declaratorId != null ? (ASTFieldDeclaration)this.declaratorId.getFirstParentOfType(ASTFieldDeclaration.class) : null;
            if (fieldDeclaration != null) {
                return fieldDeclaration.isAnnotationPresent(InvalidJavaBeanRule.LOMBOK_SETTER);
            }
            return false;
        }
    }
}

