/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEmptyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTResourceSpecification;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;

public class EmptyControlStatementRule
extends AbstractJavaRule {
    public EmptyControlStatementRule() {
        this.addRuleChainVisit(ASTFinallyStatement.class);
        this.addRuleChainVisit(ASTSynchronizedStatement.class);
        this.addRuleChainVisit(ASTTryStatement.class);
        this.addRuleChainVisit(ASTDoStatement.class);
        this.addRuleChainVisit(ASTBlock.class);
        this.addRuleChainVisit(ASTForStatement.class);
        this.addRuleChainVisit(ASTWhileStatement.class);
        this.addRuleChainVisit(ASTIfStatement.class);
        this.addRuleChainVisit(ASTSwitchStatement.class);
        this.addRuleChainVisit(ASTInitializer.class);
    }

    @Override
    public Object visit(JavaNode node, Object data) {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public Object visit(ASTFinallyStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty finally clause");
        }
        return null;
    }

    @Override
    public Object visit(ASTSynchronizedStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty synchronized statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        if (node.getNumChildren() == 1) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty switch statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        if (this.isEmpty(node) && node.getNthParent(3) instanceof ASTBlock) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty block");
        }
        return null;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (this.isEmpty((JavaNode)node.getThenBranch().getChild(0))) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty if statement");
        }
        if (node.hasElse() && this.isEmpty((JavaNode)node.getElseBranch().getChild(0))) {
            this.asCtx(data).addViolationWithMessage((Node)node.getElseBranch(), "Empty else statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty while statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        if (node.isForeach() && JavaRuleUtil.isExplicitUnusedVarName(((ASTVariableDeclaratorId)((ASTLocalVariableDeclaration)node.getFirstChildOfType(ASTLocalVariableDeclaration.class)).getFirstDescendantOfType(ASTVariableDeclaratorId.class)).getName())) {
            return null;
        }
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty for statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty do..while statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTInitializer node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty initializer statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            boolean allResourcesIgnored = true;
            boolean hasResource = false;
            ASTResourceSpecification resources = (ASTResourceSpecification)node.getFirstChildOfType(ASTResourceSpecification.class);
            if (resources != null) {
                for (ASTResource resource : resources.findDescendantsOfType(ASTResource.class)) {
                    hasResource = true;
                    String name = resource.getStableName();
                    if (JavaRuleUtil.isExplicitUnusedVarName(name)) continue;
                    allResourcesIgnored = false;
                    break;
                }
            }
            if (hasResource && !allResourcesIgnored) {
                this.asCtx(data).addViolationWithMessage((Node)node, "Empty try body - you could rename the resource to ''ignored''");
            } else if (!hasResource) {
                this.asCtx(data).addViolationWithMessage((Node)node, "Empty try body");
            }
        }
        return null;
    }

    private boolean isEmpty(JavaNode node) {
        if (node instanceof ASTStatement) {
            node = node.getChild(0);
        }
        return node instanceof ASTBlock && node.getNumChildren() == 0 || node instanceof ASTEmptyStatement;
    }
}

