/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AvoidUsingOctalValuesRule
extends AbstractJavaRule {
    public static final Pattern OCTAL_PATTERN = Pattern.compile("0[0-7]{2,}[lL]?");
    public static final Pattern STRICT_OCTAL_PATTERN = Pattern.compile("0[0-7]+[lL]?");
    private static final PropertyDescriptor<Boolean> STRICT_METHODS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"strict").desc("Detect violations between 00 and 07")).defaultValue((Object)false)).build();

    public AvoidUsingOctalValuesRule() {
        this.definePropertyDescriptor(STRICT_METHODS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        boolean strict = (Boolean)this.getProperty(STRICT_METHODS_DESCRIPTOR);
        Pattern p = strict ? STRICT_OCTAL_PATTERN : OCTAL_PATTERN;
        String img = node.getImage();
        if (img != null && p.matcher(img).matches()) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }
}

