/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class BigIntegerInstantiationRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        ASTArguments args;
        boolean jdk15;
        Node type = node.getChild(0);
        if (!(type instanceof ASTClassOrInterfaceType)) {
            return super.visit(node, data);
        }
        boolean bl = jdk15 = ((RuleContext)data).getLanguageVersion().compareTo(LanguageRegistry.getLanguage((String)"Java").getVersion("1.5")) >= 0;
        if ((TypeTestUtil.isA(BigInteger.class, (TypeNode)((ASTClassOrInterfaceType)type)) || jdk15 && TypeTestUtil.isA(BigDecimal.class, (TypeNode)((ASTClassOrInterfaceType)type))) && !node.hasDescendantOfType(ASTArrayDimsAndInits.class) && (args = (ASTArguments)node.getFirstChildOfType(ASTArguments.class)).size() == 1) {
            ASTLiteral literal = (ASTLiteral)node.getFirstDescendantOfType(ASTLiteral.class);
            if (literal == null || ((JavaNode)literal.getParent()).getParent().getParent().getParent().getParent() != args) {
                return super.visit(node, data);
            }
            String img = literal.getImage();
            if (literal.isStringLiteral()) {
                img = img.substring(1, img.length() - 1);
            }
            if ("0".equals(img) || "1".equals(img) || jdk15 && "10".equals(img)) {
                this.addViolation(data, (Node)node);
                return data;
            }
        }
        return super.visit(node, data);
    }
}

