/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typedefinition;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinitionType;

class JavaTypeDefinitionSimple
extends JavaTypeDefinition {
    private final Class<?> clazz;
    private final JavaTypeDefinition[] genericArgs;
    private final int typeParameterCount;
    private final boolean isGeneric;
    private final boolean isRawType;
    private final JavaTypeDefinition enclosingClass;
    private static final Logger LOG = Logger.getLogger(JavaTypeDefinitionSimple.class.getName());
    private static final JavaTypeDefinition[] NO_GENERICS = new JavaTypeDefinition[0];

    protected JavaTypeDefinitionSimple(Class<?> clazz, JavaTypeDefinition ... boundGenerics) {
        Class<?> enclosing;
        block2: {
            super(TypeDefinitionType.EXACT);
            this.clazz = clazz;
            TypeVariable<Class<?>>[] typeParameters = clazz.isAnonymousClass() ? (clazz.getInterfaces().length != 0 ? clazz.getInterfaces()[0].getTypeParameters() : clazz.getSuperclass().getTypeParameters()) : clazz.getTypeParameters();
            this.typeParameterCount = typeParameters.length;
            this.isGeneric = typeParameters.length != 0;
            this.isRawType = this.isGeneric && boundGenerics.length == 0;
            this.genericArgs = this.isGeneric ? Arrays.copyOf(boundGenerics, this.typeParameterCount) : NO_GENERICS;
            enclosing = null;
            try {
                enclosing = clazz.getEnclosingClass();
            }
            catch (LinkageError e) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "Could not load enclosing class of " + clazz.getName() + ", due to: " + e);
            }
        }
        this.enclosingClass = JavaTypeDefinitionSimple.forClass(enclosing, new JavaTypeDefinition[0]);
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public JavaTypeDefinition getEnclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public boolean isGeneric() {
        return this.isGeneric;
    }

    private JavaTypeDefinition getGenericType(String parameterName, Method method, List<JavaTypeDefinition> methodTypeArguments) {
        int paramIndex;
        if (method != null && methodTypeArguments != null && (paramIndex = JavaTypeDefinitionSimple.getGenericTypeIndex(method.getTypeParameters(), parameterName)) != -1) {
            return methodTypeArguments.get(paramIndex);
        }
        return this.getGenericType(parameterName);
    }

    @Override
    public JavaTypeDefinition getGenericType(String parameterName) {
        for (JavaTypeDefinition currTypeDef = this; currTypeDef != null; currTypeDef = ((JavaTypeDefinition)currTypeDef).getEnclosingClass()) {
            int paramIndex = JavaTypeDefinitionSimple.getGenericTypeIndex(((JavaTypeDefinition)currTypeDef).getType().getTypeParameters(), parameterName);
            if (paramIndex == -1) continue;
            return ((JavaTypeDefinition)currTypeDef).getGenericType(paramIndex);
        }
        StringBuilder builder = new StringBuilder("No generic parameter by name ").append(parameterName);
        for (JavaTypeDefinition currTypeDef = this; currTypeDef != null; currTypeDef = ((JavaTypeDefinition)currTypeDef).getEnclosingClass()) {
            builder.append("\n on class ");
            builder.append(((JavaTypeDefinition)currTypeDef).getType().getSimpleName());
        }
        LOG.log(Level.FINE, builder.toString());
        return JavaTypeDefinitionSimple.forClass(Object.class, new JavaTypeDefinition[0]);
    }

    @Override
    public JavaTypeDefinition getGenericType(int index) {
        JavaTypeDefinition typeDefinition;
        JavaTypeDefinition cachedDefinition = this.genericArgs[index];
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        this.genericArgs[index] = JavaTypeDefinitionSimple.forClass(Object.class, new JavaTypeDefinition[0]);
        TypeVariable<Class<?>> typeVariable = this.clazz.getTypeParameters()[index];
        this.genericArgs[index] = typeDefinition = this.resolveTypeDefinition(typeVariable.getBounds()[0]);
        return typeDefinition;
    }

    @Override
    public JavaTypeDefinition resolveTypeDefinition(Type type) {
        return this.resolveTypeDefinition(type, null, null);
    }

    @Override
    public JavaTypeDefinition resolveTypeDefinition(Type type, Method method, List<JavaTypeDefinition> methodTypeArgs) {
        if (type == null) {
            return JavaTypeDefinitionSimple.forClass(Object.class, new JavaTypeDefinition[0]);
        }
        if (type instanceof Class) {
            return JavaTypeDefinitionSimple.forClass((Class)type, new JavaTypeDefinition[0]);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            JavaTypeDefinition[] genericBounds = new JavaTypeDefinition[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                genericBounds[i] = this.resolveTypeDefinition(typeArguments[i], method, methodTypeArgs);
            }
            return JavaTypeDefinitionSimple.forClass((Class)parameterizedType.getRawType(), genericBounds);
        }
        if (type instanceof TypeVariable) {
            return this.getGenericType(((TypeVariable)type).getName(), method, methodTypeArgs);
        }
        if (type instanceof WildcardType) {
            Type[] wildcardLowerBounds = ((WildcardType)type).getLowerBounds();
            if (wildcardLowerBounds.length != 0) {
                return JavaTypeDefinitionSimple.forClass(TypeDefinitionType.LOWER_WILDCARD, this.resolveTypeDefinition(wildcardLowerBounds[0], method, methodTypeArgs));
            }
            Type[] wildcardUpperBounds = ((WildcardType)type).getUpperBounds();
            return JavaTypeDefinitionSimple.forClass(TypeDefinitionType.UPPER_WILDCARD, this.resolveTypeDefinition(wildcardUpperBounds[0], method, methodTypeArgs));
        }
        if (type instanceof GenericArrayType) {
            JavaTypeDefinition component = this.resolveTypeDefinition(((GenericArrayType)type).getGenericComponentType(), method, methodTypeArgs);
            return JavaTypeDefinitionSimple.forClass(Array.newInstance(component.getType(), 0).getClass(), new JavaTypeDefinition[0]);
        }
        return JavaTypeDefinitionSimple.forClass(Object.class, new JavaTypeDefinition[0]);
    }

    @Override
    public boolean isArrayType() {
        return this.clazz.isArray();
    }

    @Override
    public JavaTypeDefinition getComponentType() {
        Class<?> componentType = this.getType().getComponentType();
        if (componentType == null) {
            throw new IllegalStateException(this.getType().getSimpleName() + " is not an array type!");
        }
        return JavaTypeDefinitionSimple.forClass(componentType, new JavaTypeDefinition[0]);
    }

    private Class<?> getElementTypeRec(Class<?> arrayType) {
        return arrayType.isArray() ? this.getElementTypeRec(arrayType.getComponentType()) : arrayType;
    }

    @Override
    public JavaTypeDefinition getElementType() {
        return this.isArrayType() ? JavaTypeDefinitionSimple.forClass(this.getElementTypeRec(this.getType()), new JavaTypeDefinition[0]) : this;
    }

    @Override
    public JavaTypeDefinition withDimensions(int numDimensions) {
        if (numDimensions < 0) {
            throw new IllegalArgumentException("Negative array dimension");
        }
        return numDimensions == 0 ? this : JavaTypeDefinitionSimple.forClass(Array.newInstance(this.getType(), (int[])Array.newInstance(Integer.TYPE, numDimensions)).getClass(), new JavaTypeDefinition[0]);
    }

    @Override
    public boolean isClassOrInterface() {
        return !this.clazz.isEnum() && !this.clazz.isPrimitive() && !this.clazz.isAnnotation() && !this.clazz.isArray();
    }

    @Override
    public boolean isNullType() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    public boolean equivalent(JavaTypeDefinition def) {
        return this.clazz.equals(def.getType()) && this.getTypeParameterCount() == def.getTypeParameterCount();
    }

    @Override
    public boolean hasSameErasureAs(JavaTypeDefinition def) {
        return this.clazz == def.getType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.typeParameterCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("JavaTypeDefinition [clazz=").append(this.clazz).append(", definitionType=").append((Object)this.getDefinitionType()).append(", genericArgs=[");
        for (int i = 0; i < this.genericArgs.length; ++i) {
            this.getGenericType(i);
        }
        for (JavaTypeDefinition jtd : this.genericArgs) {
            sb.append(jtd.shallowString()).append(", ");
        }
        if (this.genericArgs.length != 0) {
            sb.replace(sb.length() - 3, sb.length() - 1, "");
        }
        return sb.append("], isGeneric=").append(this.isGeneric).append("]\n").toString();
    }

    @Override
    public String shallowString() {
        return "JavaTypeDefinition [clazz=" + this.clazz + ", definitionType=" + (Object)((Object)this.getDefinitionType()) + ", isGeneric=" + this.isGeneric + "]\n";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavaTypeDefinitionSimple)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JavaTypeDefinitionSimple otherTypeDef = (JavaTypeDefinitionSimple)obj;
        if (this.clazz != otherTypeDef.clazz) {
            return false;
        }
        for (int i = 0; i < this.getTypeParameterCount(); ++i) {
            if (this.getGenericType(i).equals(otherTypeDef.getGenericType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public Set<JavaTypeDefinition> getSuperTypeSet() {
        return this.getSuperTypeSet(new HashSet<JavaTypeDefinition>());
    }

    @Override
    protected Set<JavaTypeDefinition> getSuperTypeSet(Set<JavaTypeDefinition> destinationSet) {
        destinationSet.add(this);
        if (this.clazz != Object.class) {
            this.resolveTypeDefinition(this.clazz.getGenericSuperclass()).getSuperTypeSet(destinationSet);
            for (Type type : this.clazz.getGenericInterfaces()) {
                this.resolveTypeDefinition(type).getSuperTypeSet(destinationSet);
            }
        }
        return destinationSet;
    }

    @Override
    public Set<Class<?>> getErasedSuperTypeSet() {
        HashSet result = new HashSet();
        result.add(Object.class);
        return JavaTypeDefinitionSimple.getErasedSuperTypeSet(this.clazz, result);
    }

    private static Set<Class<?>> getErasedSuperTypeSet(Class<?> clazz, Set<Class<?>> destinationSet) {
        if (clazz != null) {
            destinationSet.add(clazz);
            JavaTypeDefinitionSimple.getErasedSuperTypeSet(clazz.getSuperclass(), destinationSet);
            for (Class<?> interfaceType : clazz.getInterfaces()) {
                JavaTypeDefinitionSimple.getErasedSuperTypeSet(interfaceType, destinationSet);
            }
        }
        return destinationSet;
    }

    @Override
    public JavaTypeDefinition getAsSuper(Class<?> superClazz) {
        if (Objects.equals(this.clazz, superClazz)) {
            return this;
        }
        for (JavaTypeDefinition superTypeDef : this.getSuperTypeSet()) {
            if (superTypeDef.getType() != superClazz) continue;
            return superTypeDef;
        }
        return null;
    }

    @Override
    public JavaTypeDefinition getJavaType(int index) {
        if (index == 0) {
            return this;
        }
        throw new IllegalArgumentException("Not an intersection type!");
    }

    @Override
    public int getJavaTypeCount() {
        return 1;
    }

    @Override
    public boolean isRawType() {
        return this.isRawType;
    }

    @Override
    public boolean isIntersectionType() {
        return false;
    }
}

