/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;

public class CompareObjectsWithEqualsRule
extends AbstractJavaRule {
    private boolean hasName(Node n) {
        return n.getNumChildren() > 0 && n.getChild(0) instanceof ASTName;
    }

    private boolean isAllocation(Node n) {
        return n.getNumChildren() > 0 && n.getChild(0) instanceof ASTAllocationExpression && n.getParent().getNumChildren() == 1;
    }

    @Override
    public Object visit(ASTEqualityExpression node, Object data) {
        JavaNode c0 = ((JavaNode)node.getChild(0)).getChild(0);
        JavaNode c1 = ((JavaNode)node.getChild(1)).getChild(0);
        if (this.isAllocation((Node)c0) || this.isAllocation((Node)c1)) {
            this.addViolation(data, (Node)node);
            return data;
        }
        if (!this.hasName((Node)c0) || !this.hasName((Node)c1)) {
            return data;
        }
        if (CompareObjectsWithEqualsRule.isQualifiedName(c0.getChild(0)) || CompareObjectsWithEqualsRule.isQualifiedName(c1.getChild(0))) {
            return data;
        }
        if (this.isPartOfQualifiedName(node.getChild(0)) || this.isPartOfQualifiedName(node.getChild(1))) {
            return data;
        }
        if (!node.getParentsOfType(ASTInitializer.class).isEmpty()) {
            return data;
        }
        ASTName n0 = (ASTName)c0.getChild(0);
        ASTName n1 = (ASTName)c1.getChild(0);
        if (n0.getNameDeclaration() instanceof VariableNameDeclaration && n1.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration nd0 = (VariableNameDeclaration)n0.getNameDeclaration();
            VariableNameDeclaration nd1 = (VariableNameDeclaration)n1.getNameDeclaration();
            if (nd0.isArray() || nd1.isArray()) {
                return data;
            }
            if (nd0.isReferenceType() && nd1.isReferenceType()) {
                ASTReferenceType type0 = (ASTReferenceType)nd0.getAccessNodeParent().getFirstDescendantOfType(ASTReferenceType.class);
                ASTReferenceType type1 = (ASTReferenceType)nd1.getAccessNodeParent().getFirstDescendantOfType(ASTReferenceType.class);
                if (type0.getType() != null && type0.getType().equals(type1.getType()) && (type0.getType().isEnum() || type0.getType() == Enum.class)) {
                    return data;
                }
                this.addViolation(data, (Node)node);
            }
        }
        return data;
    }

    private boolean isPartOfQualifiedName(Node node) {
        return node.getChild(0) instanceof ASTPrimaryPrefix && !node.findChildrenOfType(ASTPrimarySuffix.class).isEmpty();
    }
}

