/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class NPathComplexityRule
extends AbstractJavaMetricsRule {
    private static final Logger LOG = Logger.getLogger(NPathComplexityRule.class.getName());
    @Deprecated
    private static final PropertyDescriptor<Double> MINIMUM_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.doubleProperty((String)"minimum").desc("Deprecated! Minimum reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)200.0)).build();
    private static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("N-Path Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)200)).build();
    private int reportLevel = 200;

    public NPathComplexityRule() {
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(MINIMUM_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.reportLevel = this.getReportLevel();
        super.visit(node, data);
        return data;
    }

    private int getReportLevel() {
        double oldProp = (Double)this.getProperty(MINIMUM_DESCRIPTOR);
        if (oldProp != (Double)MINIMUM_DESCRIPTOR.defaultValue()) {
            LOG.warning("Rule NPathComplexity uses deprecated property 'minimum'. Future versions of PMD will remove support for this property. Please use 'reportLevel' instead!");
            return (int)oldProp;
        }
        return (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
    }

    @Override
    public final Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        int npath = (int)JavaMetrics.get((MetricKey<MethodLikeNode>)JavaOperationMetricKey.NPATH, (MethodLikeNode)node);
        if (npath >= this.reportLevel) {
            this.addViolation(data, node, new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", PrettyPrintingUtil.displaySignature(node), "" + npath});
        }
        return data;
    }
}

