/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetricKey;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.util.StringUtil;

public class GodClassRule
extends AbstractJavaRule {
    private static final int WMC_VERY_HIGH = 47;
    private static final int FEW_ATFD_THRESHOLD = 5;
    private static final double TCC_THRESHOLD = 0.3333333333333333;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        int wmc = (int)JavaMetrics.get(JavaClassMetricKey.WMC, node);
        double tcc = JavaMetrics.get(JavaClassMetricKey.TCC, node);
        int atfd = (int)JavaMetrics.get(JavaClassMetricKey.ATFD, node);
        super.visit(node, data);
        if (wmc >= 47 && atfd > 5 && tcc < 0.3333333333333333) {
            this.addViolation(data, node, new Object[]{wmc, StringUtil.percentageString((double)tcc, (int)3), atfd});
        }
        return data;
    }
}

