/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPImportsHandler
extends TriplePredicateHandler {
    public TPImportsHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_IMPORTS.getIRI());
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return true;
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        this.consumeTriple(subject, predicate, object);
        this.getConsumer().addOntology(subject);
        this.getConsumer().addOntology(object);
        OWLImportsDeclaration importsDeclaration = this.getDataFactory().getOWLImportsDeclaration(object);
        this.getConsumer().addImport(importsDeclaration);
        if (!this.getConsumer().getConfiguration().isIgnoredImport(object)) {
            OWLOntologyLoaderConfiguration.MissingOntologyHeaderStrategy missingOntologyHeaderStrategy;
            boolean includeGraph;
            OWLOntologyFormat importedOntologyFormat;
            OWLOntologyManager man = this.getConsumer().getOWLOntologyManager();
            man.makeLoadImportRequest(importsDeclaration, this.getConsumer().getConfiguration());
            OWLOntology importedOntology = man.getImportedOntology(importsDeclaration);
            if (importedOntology != null && (importedOntologyFormat = man.getOntologyFormat(importedOntology)) instanceof RDFOntologyFormat && importedOntology.isAnonymous() && (includeGraph = (missingOntologyHeaderStrategy = this.getConsumer().getConfiguration().getMissingOntologyHeaderStrategy()).equals((Object)OWLOntologyLoaderConfiguration.MissingOntologyHeaderStrategy.INCLUDE_GRAPH))) {
                man.applyChange((OWLOntologyChange)new RemoveImport(this.getConsumer().getOntology(), importsDeclaration));
                for (OWLImportsDeclaration decl : importedOntology.getImportsDeclarations()) {
                    man.applyChange((OWLOntologyChange)new AddImport(this.getConsumer().getOntology(), decl));
                }
                for (OWLAnnotation anno : importedOntology.getAnnotations()) {
                    man.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.getConsumer().getOntology(), anno));
                }
                for (OWLAxiom ax : importedOntology.getAxioms()) {
                    this.getConsumer().addAxiom(ax);
                }
                man.removeOntology(importedOntology);
            }
            this.getConsumer().importsClosureChanged();
        }
    }
}

