/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.SpeechEventWrapper;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.speech.EngineProperties;
import javax.speech.SpeechError;
import javax.speech.SpeechEvent;

public abstract class BaseEngineProperties
implements EngineProperties,
SpeechEventDispatcher {
    protected Collection propertyChangeListeners = new ArrayList();

    protected BaseEngineProperties() {
    }

    public Component getControlComponent() {
        return null;
    }

    public abstract void reset();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void postPropertyChangeEvent(String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, oldValue, newValue);
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    protected void postPropertyChangeEvent(String propName, float oldValue, float newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, new Float(oldValue), new Float(newValue));
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    protected void postPropertyChangeEvent(String propName, int oldValue, int newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, new Integer(oldValue), new Integer(newValue));
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    protected void postPropertyChangeEvent(String propName, boolean oldValue, boolean newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, new Boolean(oldValue), new Boolean(newValue));
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.propertyChangeListeners == null) {
            return;
        }
        Iterator iterator = this.propertyChangeListeners.iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener pl = (PropertyChangeListener)iterator.next();
            pl.propertyChange(event);
        }
    }

    public void dispatchSpeechEvent(SpeechEvent event) {
        if (!(event instanceof SpeechEventWrapper)) {
            throw new SpeechError("BaseEngineProperties: speech event type error");
        }
        SpeechEventWrapper se = (SpeechEventWrapper)event;
        PropertyChangeEvent pe = (PropertyChangeEvent)se.getEventObject();
        this.firePropertyChangeEvent(pe);
    }
}

