/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.web.AlreadyCommittedException;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.Header;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import net.sf.ehcache.constructs.web.ResponseUtil;
import net.sf.ehcache.constructs.web.SerializableCookie;
import net.sf.ehcache.constructs.web.filter.Filter;
import net.sf.ehcache.constructs.web.filter.FilterNonReentrantException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingFilter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CachingFilter.class);
    private static final String BLOCKING_TIMEOUT_MILLIS = "blockingTimeoutMillis";
    private static final String CACHE_NAME = "cacheName";
    protected String cacheName;
    protected BlockingCache blockingCache;
    private final VisitLog visitLog = new VisitLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInit(FilterConfig filterConfig) throws CacheException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.blockingCache == null) {
                this.setCacheNameIfAnyConfigured(filterConfig);
                String localCacheName = this.getCacheName();
                Ehcache cache = this.getCacheManager().getEhcache(localCacheName);
                if (cache == null) {
                    throw new CacheException("cache '" + localCacheName + "' not found in configuration");
                }
                if (!(cache instanceof BlockingCache)) {
                    BlockingCache newBlockingCache = new BlockingCache(cache);
                    this.getCacheManager().replaceCacheWithDecoratedCache(cache, (Ehcache)newBlockingCache);
                }
                this.blockingCache = (BlockingCache)this.getCacheManager().getEhcache(localCacheName);
                Integer blockingTimeoutMillis = this.parseBlockingCacheTimeoutMillis(filterConfig);
                if (blockingTimeoutMillis != null && blockingTimeoutMillis > 0) {
                    this.blockingCache.setTimeoutMillis(blockingTimeoutMillis.intValue());
                }
            }
        }
    }

    Integer parseBlockingCacheTimeoutMillis(FilterConfig filterConfig) {
        String timeout = filterConfig.getInitParameter(BLOCKING_TIMEOUT_MILLIS);
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void setCacheNameIfAnyConfigured(FilterConfig filterConfig) {
        this.cacheName = filterConfig.getInitParameter(CACHE_NAME);
    }

    protected void doDestroy() {
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, AlreadyCommittedException, FilterNonReentrantException, LockTimeoutException, Exception {
        if (response.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed before doing buildPage.");
        }
        this.logRequestHeaders(request);
        PageInfo pageInfo = this.buildPageInfo(request, response, chain);
        if (pageInfo.isOk()) {
            if (response.isCommitted()) {
                throw new AlreadyCommittedException("Response already committed after doing buildPage but before writing response from PageInfo.");
            }
            this.writeResponse(request, response, pageInfo);
        }
    }

    protected PageInfo buildPageInfo(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        PageInfo pageInfo;
        block12: {
            String key = this.calculateKey(request);
            pageInfo = null;
            try {
                this.checkNoReentry(request);
                Element element = this.blockingCache.get((Serializable)((Object)key));
                if (element == null || element.getObjectValue() == null) {
                    try {
                        pageInfo = this.buildPage(request, response, chain);
                        if (pageInfo.isOk()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("PageInfo ok. Adding to cache " + this.blockingCache.getName() + " with key " + key);
                            }
                            this.blockingCache.put(new Element((Serializable)((Object)key), (Serializable)pageInfo));
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("PageInfo was not ok(200). Putting null into cache " + this.blockingCache.getName() + " with key " + key);
                            }
                            this.blockingCache.put(new Element((Serializable)((Object)key), null));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        this.blockingCache.put(new Element((Serializable)((Object)key), null));
                        throw new Exception(throwable);
                    }
                }
                pageInfo = (PageInfo)element.getObjectValue();
            }
            catch (LockTimeoutException e) {
                throw e;
            }
            finally {
                this.visitLog.clear();
            }
        }
        return pageInfo;
    }

    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, Exception {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        GenericResponseWrapper wrapper = new GenericResponseWrapper(response, outstr);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        wrapper.flush();
        long timeToLiveSeconds = this.blockingCache.getCacheConfiguration().getTimeToLiveSeconds();
        return new PageInfo(wrapper.getStatus(), wrapper.getContentType(), wrapper.getCookies(), outstr.toByteArray(), true, timeToLiveSeconds, wrapper.getAllHeaders());
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, DataFormatException, ResponseHeadersNotModifiableException {
        boolean requestAcceptsGzipEncoding = this.acceptsGzipEncoding(request);
        this.setStatus(response, pageInfo);
        this.setContentType(response, pageInfo);
        this.setCookies(pageInfo, response);
        this.setHeaders(pageInfo, requestAcceptsGzipEncoding, response);
        this.writeContent(request, response, pageInfo);
    }

    protected void setContentType(HttpServletResponse response, PageInfo pageInfo) {
        String contentType = pageInfo.getContentType();
        if (contentType != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
    }

    protected void setCookies(PageInfo pageInfo, HttpServletResponse response) {
        List cookies = pageInfo.getSerializableCookies();
        Iterator iterator = cookies.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = ((SerializableCookie)iterator.next()).toCookie();
            response.addCookie(cookie);
        }
    }

    protected void setStatus(HttpServletResponse response, PageInfo pageInfo) {
        response.setStatus(pageInfo.getStatusCode());
    }

    protected void setHeaders(PageInfo pageInfo, boolean requestAcceptsGzipEncoding, HttpServletResponse response) {
        List<Header<? extends Serializable>> headers = pageInfo.getHeaders();
        TreeSet<String> setHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        block5: for (Header header : headers) {
            String name = header.getName();
            switch (header.getType()) {
                case STRING: {
                    if (setHeaders.contains(name)) {
                        response.addHeader(name, (String)header.getValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setHeader(name, (String)header.getValue());
                    continue block5;
                }
                case DATE: {
                    if (setHeaders.contains(name)) {
                        response.addDateHeader(name, ((Long)header.getValue()).longValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setDateHeader(name, ((Long)header.getValue()).longValue());
                    continue block5;
                }
                case INT: {
                    if (setHeaders.contains(name)) {
                        response.addIntHeader(name, ((Integer)header.getValue()).intValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setIntHeader(name, ((Integer)header.getValue()).intValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("No mapping for Header: " + header);
        }
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    protected abstract CacheManager getCacheManager();

    protected abstract String calculateKey(HttpServletRequest var1);

    protected void writeContent(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, ResponseHeadersNotModifiableException {
        byte[] body;
        boolean shouldBodyBeZero = ResponseUtil.shouldBodyBeZero(request, pageInfo.getStatusCode());
        if (shouldBodyBeZero) {
            body = new byte[]{};
        } else if (this.acceptsGzipEncoding(request)) {
            body = pageInfo.getGzippedBody();
            if (ResponseUtil.shouldGzippedBodyBeZero(body, request)) {
                body = new byte[]{};
            } else {
                ResponseUtil.addGzipHeader(response);
            }
        } else {
            body = pageInfo.getUngzippedBody();
        }
        response.setContentLength(body.length);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)out).write(body);
        ((OutputStream)out).flush();
    }

    protected void checkNoReentry(HttpServletRequest httpRequest) throws FilterNonReentrantException {
        String filterName = this.getClass().getName();
        if (this.visitLog.hasVisited()) {
            throw new FilterNonReentrantException("The request thread is attempting to reenter filter " + filterName + ". URL: " + httpRequest.getRequestURL());
        }
        this.visitLog.markAsVisited();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread {}  has been marked as visited.", (Object)Thread.currentThread().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VisitLog
    extends ThreadLocal<Boolean> {
        private VisitLog() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }

        public boolean hasVisited() {
            return (Boolean)this.get();
        }

        public void markAsVisited() {
            this.set(true);
        }

        public void clear() {
            this.set(false);
        }
    }
}

