/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import it.unimi.dsi.big.util.MappedFrontCodedStringBigList;
import it.unimi.dsi.fastutil.bytes.ByteArrayFrontCodedBigList;
import it.unimi.dsi.fastutil.chars.CharArrayFrontCodedBigList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.Properties;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.zip.GZIPInputStream;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontCodedStringBigList
extends AbstractObjectBigList<MutableString>
implements RandomAccess,
Serializable {
    public static final long serialVersionUID = 1L;
    protected final ByteArrayFrontCodedBigList byteFrontCodedBigList;
    protected final CharArrayFrontCodedBigList charFrontCodedBigList;
    protected final boolean utf8;

    public FrontCodedStringBigList(final Iterator<? extends CharSequence> words, int ratio, boolean utf8) {
        this.utf8 = utf8;
        if (utf8) {
            this.byteFrontCodedBigList = new ByteArrayFrontCodedBigList((Iterator)new ObjectIterator<byte[]>(){

                public boolean hasNext() {
                    return words.hasNext();
                }

                public byte[] next() {
                    return ((CharSequence)words.next()).toString().getBytes(Charsets.UTF_8);
                }
            }, ratio);
            this.charFrontCodedBigList = null;
        } else {
            this.charFrontCodedBigList = new CharArrayFrontCodedBigList((Iterator)new ObjectIterator<char[]>(){

                public boolean hasNext() {
                    return words.hasNext();
                }

                public char[] next() {
                    CharSequence s = (CharSequence)words.next();
                    int i = s.length();
                    char[] a = new char[i];
                    while (i-- != 0) {
                        a[i] = s.charAt(i);
                    }
                    return a;
                }
            }, ratio);
            this.byteFrontCodedBigList = null;
        }
    }

    public FrontCodedStringBigList(Collection<? extends CharSequence> c, int ratio, boolean utf8) {
        this(c.iterator(), ratio, utf8);
    }

    public boolean utf8() {
        return this.utf8;
    }

    public int ratio() {
        return this.utf8 ? this.byteFrontCodedBigList.ratio() : this.charFrontCodedBigList.ratio();
    }

    public MutableString get(long index) {
        return MutableString.wrap(this.utf8 ? FrontCodedStringBigList.byte2Char(this.byteFrontCodedBigList.getArray(index), null) : this.charFrontCodedBigList.getArray(index));
    }

    public void get(long index, MutableString s) {
        if (this.utf8) {
            byte[] a = this.byteFrontCodedBigList.getArray(index);
            s.length(FrontCodedStringBigList.countUTF8Chars(a));
            FrontCodedStringBigList.byte2Char(a, s.array());
        } else {
            s.length(s.array().length);
            int res = this.charFrontCodedBigList.get(index, s.array());
            if (res < 0) {
                s.length(s.array().length - res);
                res = this.charFrontCodedBigList.get(index, s.array());
            } else {
                s.length(res);
            }
        }
    }

    protected static int countUTF8Chars(byte[] a) {
        int length = a.length;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int b = (a[i] & 0xFF) >> 4;
            if (b < 8) {
                ++result;
                continue;
            }
            if (b < 14) {
                ++result;
                ++i;
                continue;
            }
            if (b < 15) {
                ++result;
                i += 2;
                continue;
            }
            result += 2;
            i += 4;
        }
        return result;
    }

    protected static char[] byte2Char(byte[] a, char[] s) {
        int length = a.length;
        if (s == null) {
            s = new char[FrontCodedStringBigList.countUTF8Chars(a)];
        }
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int c;
            int b = a[i] & 0xFF;
            int t = b >> 4;
            if (t < 8) {
                s[j++] = (char)b;
                continue;
            }
            if (t < 14) {
                if (((c = a[++i] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0x1F) << 6 | c & 0x3F);
                continue;
            }
            if (t < 15) {
                c = a[++i] & 0xFF;
                byte d = a[++i];
                if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | (d & 0x3F) << 0);
                continue;
            }
            String surrogatePair = new String(a, i, 4, Charsets.UTF_8);
            s[j++] = surrogatePair.charAt(0);
            s[j++] = surrogatePair.charAt(1);
            i += 3;
        }
        return s;
    }

    public ObjectBigListIterator<MutableString> listIterator(final long k) {
        return new ObjectBigListIterator<MutableString>(){
            ObjectBigListIterator<?> i;
            {
                this.i = FrontCodedStringBigList.this.utf8 ? FrontCodedStringBigList.this.byteFrontCodedBigList.listIterator(k) : FrontCodedStringBigList.this.charFrontCodedBigList.listIterator(k);
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public MutableString next() {
                return MutableString.wrap(FrontCodedStringBigList.this.utf8 ? FrontCodedStringBigList.byte2Char((byte[])this.i.next(), null) : (char[])this.i.next());
            }

            public MutableString previous() {
                return MutableString.wrap(FrontCodedStringBigList.this.utf8 ? FrontCodedStringBigList.byte2Char((byte[])this.i.previous(), null) : (char[])this.i.previous());
            }

            public long nextIndex() {
                return this.i.nextIndex();
            }

            public long previousIndex() {
                return this.i.previousIndex();
            }
        };
    }

    public long size64() {
        return this.utf8 ? this.byteFrontCodedBigList.size64() : this.charFrontCodedBigList.size64();
    }

    public void dump(String basename) throws ConfigurationException, IOException {
        if (!this.utf8) {
            throw new IllegalStateException("You can dump UTF-8-based lists, only");
        }
        Properties properties = new Properties();
        properties.setProperty((Enum<?>)MappedFrontCodedStringBigList.PropertyKeys.N, this.byteFrontCodedBigList.size64());
        properties.setProperty((Enum<?>)MappedFrontCodedStringBigList.PropertyKeys.RATIO, this.byteFrontCodedBigList.ratio());
        properties.save(basename + ".properties");
        DataOutputStream arrayDos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + ".bytearray")));
        DataOutputStream pointerDos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + ".pointers")));
        this.byteFrontCodedBigList.dump(arrayDos, pointerDos);
        arrayDos.close();
        pointerDos.close();
    }

    public static void main(String[] arg) throws IOException, JSAPException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(FrontCodedStringBigList.class.getName(), "Builds a front-coded string list reading from standard input a newline-separated ordered list of strings.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)IntSizeStringParser.getParser(), "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read strings."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The file encoding."), new FlaggedOption("ratio", (StringParser)IntSizeStringParser.getParser(), "4", false, 'r', "ratio", "The compression ratio."), new Switch("utf8", 'u', "utf8", "Store the strings as UTF-8 byte arrays."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("frontCodedList", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised front-coded list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        int ratio = jsapResult.getInt("ratio");
        boolean utf8 = jsapResult.getBoolean("utf8");
        boolean zipped = jsapResult.getBoolean("zipped");
        String listName = jsapResult.getString("frontCodedList");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        Logger logger = LoggerFactory.getLogger(FrontCodedStringBigList.class);
        ProgressLogger pl = new ProgressLogger(logger);
        pl.displayFreeMemory = true;
        pl.displayLocalSpeed = true;
        pl.itemsName = "strings";
        pl.start("Reading strings...");
        FrontCodedStringBigList frontCodedStringBigList = new FrontCodedStringBigList((Iterator<? extends CharSequence>)((Object)new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding), bufferSize), pl)), ratio, utf8);
        pl.done();
        logger.info("Writing front-coded list to file...");
        BinIO.storeObject((Object)frontCodedStringBigList, (CharSequence)listName);
        logger.info("Completed.");
    }
}

