/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.FileParser;

public abstract class AbstractFileParser
implements FileParser {
    private final Log log;
    private final TreeSet<String> result;
    private boolean touched;
    private final String encoding;
    protected final Pattern acceptKeyPattern;

    protected AbstractFileParser(Log log, String encoding, Pattern acceptKeyPattern) {
        this.log = log;
        this.encoding = encoding;
        this.result = new TreeSet();
        this.acceptKeyPattern = acceptKeyPattern;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public TreeSet<String> getResult() {
        return this.result;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void destroy() {
        this.result.clear();
        this.touched = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public Log getLog() {
        return this.log;
    }

    protected void registerKey(File file, String key) {
        Matcher matcher;
        if (this.acceptKeyPattern != null && !(matcher = this.acceptKeyPattern.matcher(key)).matches()) {
            return;
        }
        this.getResult().add(key);
        this.touched = true;
    }

    protected File prepareFile(File file) throws IOException {
        return file;
    }
}

