/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedSetMultimap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.I18nMojoSupport;
import org.nuiton.i18n.plugin.bundle.BundleValidation;
import org.nuiton.io.SortedProperties;

@Mojo(name="check-bundles-integrity", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class CheckBundlesIntegrityMojo
extends I18nMojoSupport {
    @Parameter(property="i18n.sourceDirectory", defaultValue="${basedir}/src/main/i18n", required=true)
    private File sourceDirectory;
    @Parameter(property="i18n.showEmpty", defaultValue="false", required=true)
    private boolean showEmpty;
    @Parameter(property="i18n.showMissing", defaultValue="false", required=true)
    private boolean showMissing;
    @Parameter(property="i18n.failsIfWarning", defaultValue="false")
    private boolean failsIfWarning;

    protected void doAction() throws Exception {
        Locale locale2;
        if (!this.silent) {
            this.getLog().info((CharSequence)String.format("config - sourceDirectory : %s", this.sourceDirectory.getAbsolutePath()));
            this.getLog().info((CharSequence)String.format("config - locales         : %s", Arrays.toString(this.locales)));
        }
        BundleValidation bundleValidation = new BundleValidation(this.locales);
        for (Locale locale2 : this.locales) {
            File bundleSrc = this.getI18nFile(this.sourceDirectory, this.artifactId, locale2, false);
            SortedProperties propertiesSrc = new SortedProperties(this.encoding);
            if (bundleSrc.exists()) {
                propertiesSrc.load(bundleSrc);
            }
            this.checkBundle(locale2, (Properties)propertiesSrc, this.showEmpty, bundleValidation);
            ImmutableSet keys = Maps.fromProperties((Properties)propertiesSrc).keySet();
            bundleValidation.getKeysPerLocale().putAll((Object)locale2, (Iterable)keys);
        }
        SortedSetMultimap<Locale, String> missingKeysPerLocale = bundleValidation.getMissingKeysPerLocale();
        if (missingKeysPerLocale.isEmpty()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)String.format("all locales for bundle %s are consistent", this.artifactId));
            }
        } else if (this.showMissing) {
            for (Map.Entry entry : missingKeysPerLocale.entries()) {
                locale2 = (Locale)entry.getKey();
                String missingKey = (String)entry.getValue();
                this.getLog().warn((CharSequence)String.format("bundle %s for locale %s misses key %s", this.artifactId, locale2, missingKey));
            }
        } else {
            for (Map.Entry entry : missingKeysPerLocale.asMap().entrySet()) {
                locale2 = (Locale)entry.getKey();
                int numberOfMissingKeys = ((Collection)entry.getValue()).size();
                this.getLog().warn((CharSequence)String.format("bundle %s for locale %s misses %d keys! (use -Di18n.showMissing to see these entries)", this.artifactId, locale2, numberOfMissingKeys));
            }
        }
        if (this.failsIfWarning && bundleValidation.isFail()) {
            throw new MojoFailureException("Bundles validation failed, see warning above for details about how to fix");
        }
    }
}

