/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.Resource;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.ProjectClasspathDigester;
import io.takari.maven.plugins.compile.javac.AbstractCompilerJavac;
import io.takari.maven.plugins.compile.javac.FileObjects;
import io.takari.maven.plugins.compile.javac.RecordingJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;

@Named(value="javac")
public class CompilerJavac
extends AbstractCompilerJavac {
    public static final String ID = "javac";
    private static JavaCompiler compiler;

    static synchronized JavaCompiler getSystemJavaCompiler() throws MojoExecutionException {
        if (compiler == null) {
            compiler = ToolProvider.getSystemJavaCompiler();
        }
        if (compiler == null) {
            throw new MojoExecutionException("No compiler is provided in this environment. Perhaps you are running on a JRE rather than a JDK?");
        }
        return compiler;
    }

    @Inject
    public CompilerJavac(CompilerBuildContext context, ProjectClasspathDigester digester) {
        super(context, digester);
    }

    @Override
    public int compile(Map<File, Resource<File>> sources) throws MojoExecutionException, IOException {
        if (sources.isEmpty()) {
            return 0;
        }
        JavaCompiler compiler = CompilerJavac.getSystemJavaCompiler();
        StandardJavaFileManager javaFileManager = compiler.getStandardFileManager(null, null, this.getSourceEncoding());
        try {
            this.compile(compiler, javaFileManager, sources);
        }
        finally {
            javaFileManager.flush();
            javaFileManager.close();
        }
        return sources.size();
    }

    private void compile(JavaCompiler compiler, StandardJavaFileManager javaFileManager, Map<File, Resource<File>> sources) throws IOException {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        Iterable<? extends JavaFileObject> javaSources = javaFileManager.getJavaFileObjectsFromFiles(sources.keySet());
        final HashMap outputs = new HashMap();
        List<String> options = this.getCompilerOptions();
        RecordingJavaFileManager recordingFileManager = new RecordingJavaFileManager(javaFileManager, this.getSourceEncoding()){

            @Override
            protected void record(File inputFile, File outputFile) {
                outputs.put(outputFile, CompilerJavac.this.context.processOutput(outputFile));
            }
        };
        PrintWriter stdout = new PrintWriter(System.out, true);
        JavaCompiler.CompilationTask task = compiler.getTask(stdout, recordingFileManager, diagnosticCollector, options, null, javaSources);
        boolean success = task.call();
        for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
            JavaFileObject source = (JavaFileObject)diagnostic.getSource();
            MessageSeverity severity = this.toSeverity(diagnostic.getKind(), success);
            String message = diagnostic.getMessage(null);
            if (!this.isShowWarnings() && severity == MessageSeverity.WARNING) continue;
            if (source != null) {
                File file = FileObjects.toFile(source);
                if (file != null) {
                    Resource resource = sources.get(file);
                    if (resource == null) {
                        resource = (Resource)outputs.get(file);
                    }
                    if (resource != null) {
                        resource.addMessage((int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), message, severity, null);
                        continue;
                    }
                    this.log.warn("Unexpected java {} resource {}", (Object)source.getKind(), (Object)source.toUri().toASCIIString());
                    continue;
                }
                this.log.warn("Unsupported compiler message on {} resource {}: {}", new Object[]{source.getKind(), source.toUri(), message});
                continue;
            }
            this.context.addPomMessage(message, severity, null);
        }
    }

    private MessageSeverity toSeverity(Diagnostic.Kind kind, boolean success) {
        MessageSeverity severity;
        if (success && kind == Diagnostic.Kind.ERROR) {
            kind = Diagnostic.Kind.WARNING;
        }
        switch (kind) {
            case ERROR: {
                severity = MessageSeverity.ERROR;
                break;
            }
            case NOTE: {
                severity = MessageSeverity.INFO;
                break;
            }
            default: {
                severity = MessageSeverity.WARNING;
            }
        }
        return severity;
    }

    @Override
    protected String getCompilerId() {
        return ID;
    }
}

