/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.oas.integration;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.integration.IgnoredPackages;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiScanner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericOpenApiScanner
implements OpenApiScanner {
    static final Set<String> ignored = new HashSet<String>();
    private static Logger LOGGER;
    OpenAPIConfiguration openApiConfiguration;

    @Override
    public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
        this.openApiConfiguration = openApiConfiguration;
    }

    @Override
    public Set<Class<?>> classes() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        HashSet<String> acceptablePackages = new HashSet<String>();
        HashSet resourceClasses = new HashSet();
        HashSet output = new HashSet();
        boolean allowAllPackages = false;
        if (this.openApiConfiguration.getResourceClasses() != null && !this.openApiConfiguration.getResourceClasses().isEmpty()) {
            for (String className : this.openApiConfiguration.getResourceClasses()) {
                if (this.isIgnored(className)) continue;
                try {
                    output.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("error loading class from resourceClasses: " + e.getMessage(), (Throwable)e);
                }
            }
            return output;
        }
        if (this.openApiConfiguration.getResourcePackages() != null && !this.openApiConfiguration.getResourcePackages().isEmpty()) {
            for (String pkg : this.openApiConfiguration.getResourcePackages()) {
                if (this.isIgnored(pkg)) continue;
                acceptablePackages.add(pkg);
                config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            }
        } else {
            allowAllPackages = true;
        }
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Set classes = reflections.getTypesAnnotatedWith(OpenAPIDefinition.class);
        for (Class cls : classes) {
            if (allowAllPackages) {
                output.add(cls);
                continue;
            }
            for (String pkg : acceptablePackages) {
                if (!cls.getPackage().getName().startsWith(pkg)) continue;
                output.add(cls);
            }
        }
        return output;
    }

    @Override
    public Map<String, Object> resources() {
        return new HashMap<String, Object>();
    }

    protected boolean isIgnored(String classOrPackageName) {
        if (StringUtils.isBlank((CharSequence)classOrPackageName)) {
            return true;
        }
        return ignored.stream().anyMatch(i -> classOrPackageName.startsWith((String)i));
    }

    static {
        ignored.addAll(IgnoredPackages.ignored);
        LOGGER = LoggerFactory.getLogger(GenericOpenApiScanner.class);
    }
}

