/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.callback;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.paths.PathsWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;

public class CallbackWriter {
    private CallbackWriter() {
    }

    public static void writeCallbacks(ObjectNode parent, Map<String, Callback> callbacks) {
        if (callbacks == null) {
            return;
        }
        ObjectNode callbacksNode = parent.putObject("callbacks");
        Set<Map.Entry<String, Callback>> entrySet = callbacks.entrySet();
        for (Map.Entry<String, Callback> entry : entrySet) {
            CallbackWriter.writeCallback(callbacksNode, entry.getValue(), entry.getKey());
        }
    }

    private static void writeCallback(ObjectNode parent, Callback model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            if (model.getPathItems() != null) {
                Set entrySet = model.getPathItems().entrySet();
                for (Map.Entry entry : entrySet) {
                    PathsWriter.writePathItem(node, (PathItem)entry.getValue(), (String)entry.getKey());
                }
            }
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

