/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.header;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.content.ContentWriter;
import io.smallrye.openapi.runtime.io.example.ExampleWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.schema.SchemaWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.headers.Header;

public class HeaderWriter {
    private HeaderWriter() {
    }

    public static void writeHeaders(ObjectNode parent, Map<String, Header> headers) {
        if (headers == null) {
            return;
        }
        ObjectNode headersNode = parent.putObject("headers");
        for (Map.Entry<String, Header> entry : headers.entrySet()) {
            HeaderWriter.writeHeader(headersNode, entry.getValue(), entry.getKey());
        }
    }

    private static void writeHeader(ObjectNode parent, Header model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "description", model.getDescription());
            JsonUtil.booleanProperty(node, "required", model.getRequired());
            JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
            JsonUtil.booleanProperty(node, "allowEmptyValue", model.getAllowEmptyValue());
            JsonUtil.enumProperty(node, "style", model.getStyle());
            JsonUtil.booleanProperty(node, "explode", model.getExplode());
            SchemaWriter.writeSchema(node, model.getSchema(), "schema");
            ObjectWriter.writeObject(node, "example", model.getExample());
            ExampleWriter.writeExamples(node, model.getExamples());
            ContentWriter.writeContent(node, model.getContent());
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

