package io.vertx.mutiny.core.cli;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.cli.Option;
import java.util.List;
import io.vertx.core.cli.Argument;

/**
 * The parser transforms a CLI (a model) into an {@link io.vertx.mutiny.core.cli.CommandLine}. This {@link io.vertx.mutiny.core.cli.CommandLine}
 * has stored the argument and option values. Only  instance of parser should create
 * objects of this type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.cli.CommandLine original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.cli.CommandLine.class)
public class CommandLine implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<CommandLine> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CommandLine((io.vertx.core.cli.CommandLine) obj),
    CommandLine::getDelegate
  );

  private final io.vertx.core.cli.CommandLine delegate;
  
  public CommandLine(io.vertx.core.cli.CommandLine delegate) {
    this.delegate = delegate;
  }

  public CommandLine(Object delegate) {
    this.delegate = (io.vertx.core.cli.CommandLine)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CommandLine() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.cli.CommandLine getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandLine that = (CommandLine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param cli the CLI definition
   * @return the command line object
   */
  public static io.vertx.mutiny.core.cli.CommandLine create(io.vertx.mutiny.core.cli.CLI cli) { 
    io.vertx.mutiny.core.cli.CommandLine ret = io.vertx.mutiny.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)io.vertx.core.cli.CommandLine.create(cli.getDelegate()));
    return ret;
  }

  /**
   * @return the model of this command line object.
   */
  public io.vertx.mutiny.core.cli.CLI cli() { 
    io.vertx.mutiny.core.cli.CLI ret = io.vertx.mutiny.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)delegate.cli());
    return ret;
  }

  /**
   * @return the ordered list of arguments. Arguments are command line arguments not matching an option.
   */
  public List<String> allArguments() { 
    List<String> ret = delegate.allArguments();
    return ret;
  }

  /**
   * @param name the name
   * @return the value, <code>null</code> if not set
   */
  public <T> T getOptionValue(String name) { 
    T ret = (T) delegate.getOptionValue(name);
    return ret;
  }

  /**
   * @param name the name
   * @return the value, <code>null</code> if not set
   */
  public <T> T getArgumentValue(String name) { 
    T ret = (T) delegate.getArgumentValue(name);
    return ret;
  }

  /**
   * @param index the index
   * @return the value, <code>null</code> if not set
   */
  public <T> T getArgumentValue(int index) { 
    T ret = (T) delegate.getArgumentValue(index);
    return ret;
  }

  /**
   * @param name the option name
   * @return <code>true</code> if the flag has been set in the command line, <code>false</code> otherwise.
   */
  public boolean isFlagEnabled(String name) { 
    boolean ret = delegate.isFlagEnabled(name);
    return ret;
  }

  /**
   * @param option the option
   * @return <code>true</code> if the option has received a value,  otherwise.
   */
  public boolean isOptionAssigned(io.vertx.core.cli.Option option) { 
    boolean ret = delegate.isOptionAssigned(option);
    return ret;
  }

  /**
   * @param option the option
   * @return the list of values, empty if none
   * @deprecated use {@link #getRawValuesForOption(Option)}   */
  @Deprecated
  public List<String> getRawValues(io.vertx.core.cli.Option option) { 
    List<String> ret = delegate.getRawValues(option);
    return ret;
  }

  /**
   * @param option the option
   * @return the list of values, empty if none
   */
  public List<String> getRawValuesForOption(io.vertx.core.cli.Option option) { 
    List<String> ret = delegate.getRawValuesForOption(option);
    return ret;
  }

  /**
   * @param argument the argument
   * @return the list of values, empty if none
   */
  public List<String> getRawValuesForArgument(io.vertx.core.cli.Argument argument) { 
    List<String> ret = delegate.getRawValuesForArgument(argument);
    return ret;
  }

  /**
   * @param option the option
   * @return the value, <code>null</code> if none.
   */
  public String getRawValueForOption(io.vertx.core.cli.Option option) { 
    String ret = delegate.getRawValueForOption(option);
    return ret;
  }

  /**
   * @param option the option
   * @return  if the option accepts more values,  otherwise.
   */
  public boolean acceptMoreValues(io.vertx.core.cli.Option option) { 
    boolean ret = delegate.acceptMoreValues(option);
    return ret;
  }

  /**
   * @param arg the argument
   * @return the value, <code>null</code> if none.
   */
  public String getRawValueForArgument(io.vertx.core.cli.Argument arg) { 
    String ret = delegate.getRawValueForArgument(arg);
    return ret;
  }

  /**
   * @param arg the argument
   * @return <code>true</code> if the argument has received a value,  otherwise.
   */
  public boolean isArgumentAssigned(io.vertx.core.cli.Argument arg) { 
    boolean ret = delegate.isArgumentAssigned(arg);
    return ret;
  }

  /**
   * @param option the option
   * @return <code>true</code> if the user command line has used the option
   */
  public boolean isSeenInCommandLine(io.vertx.core.cli.Option option) { 
    boolean ret = delegate.isSeenInCommandLine(option);
    return ret;
  }

  /**
   * @return <code>true</code> if the current {@link io.vertx.mutiny.core.cli.CommandLine} object is valid.  otherwise.
   */
  public boolean isValid() { 
    boolean ret = delegate.isValid();
    return ret;
  }

  /**
   * @return <code>true</code> if the user command line has enabled a "Help" option,  otherwise.
   */
  public boolean isAskingForHelp() { 
    boolean ret = delegate.isAskingForHelp();
    return ret;
  }

  public static  CommandLine newInstance(io.vertx.core.cli.CommandLine arg) {
    return arg != null ? new CommandLine(arg) : null;
  }

}
