package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;

/**
 * An asynchronous exclusive lock which can be obtained from any node in the cluster.
 * <p>
 * When the lock is obtained, no-one else in the cluster can obtain the lock with the same name until the lock
 * is released.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Lock original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.Lock.class)
public class Lock {

  public static final io.smallrye.mutiny.vertx.TypeArg<Lock> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Lock((io.vertx.core.shareddata.Lock) obj),
    Lock::getDelegate
  );

  private final io.vertx.core.shareddata.Lock delegate;
  
  public Lock(io.vertx.core.shareddata.Lock delegate) {
    this.delegate = delegate;
  }

  public Lock(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.Lock)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Lock() {
    this.delegate = null;
  }

  public io.vertx.core.shareddata.Lock getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Lock that = (Lock) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   */
  public void release() { 
    delegate.release();
  }

  public static  Lock newInstance(io.vertx.core.shareddata.Lock arg) {
    return arg != null ? new Lock(arg) : null;
  }

}
