package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Shared data allows you to share data safely between different parts of your application in a safe way.
 * <p>
 * Shared data provides:
 * <ul>
 *   <li>synchronous shared maps (local)</li>
 *   <li>asynchronous maps (local or cluster-wide)</li>
 *   <li>asynchronous locks (local or cluster-wide)</li>
 *   <li>asynchronous counters (local or cluster-wide)</li>
 * </ul>
 * <p>
 * <p>
 *   <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
 *   Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
 * </p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.SharedData original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.SharedData.class)
public class SharedData {

  public static final io.smallrye.mutiny.vertx.TypeArg<SharedData> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SharedData((io.vertx.core.shareddata.SharedData) obj),
    SharedData::getDelegate
  );

  private final io.vertx.core.shareddata.SharedData delegate;
  
  public SharedData(io.vertx.core.shareddata.SharedData delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  SharedData() {    this.delegate = null;
  }

  public io.vertx.core.shareddata.SharedData getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SharedData that = (SharedData) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  private <K, V> void __getClusterWideMap(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getClusterWideMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.AsyncMap.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the map
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <K, V> Uni<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>> getClusterWideMap(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getClusterWideMap(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getClusterWideMap(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the map
   * @return the AsyncMap<K,V> instance produced by the operation
   */
  public <K, V> io.vertx.mutiny.core.shareddata.AsyncMap<K, V> getClusterWideMapAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.AsyncMap<K, V>) getClusterWideMap(name).await().indefinitely();
  }

  /**
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  private <K, V> void __getAsyncMap(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.AsyncMap.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the {@link io.vertx.mutiny.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the map
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <K, V> Uni<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>> getAsyncMap(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getAsyncMap(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getAsyncMap(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the map
   * @return the AsyncMap<K,V> instance produced by the operation
   */
  public <K, V> io.vertx.mutiny.core.shareddata.AsyncMap<K, V> getAsyncMapAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.AsyncMap<K, V>) getAsyncMap(name).await().indefinitely();
  }

  /**
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  private <K, V> void __getLocalAsyncMap(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getLocalAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.AsyncMap.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the {@link io.vertx.mutiny.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the map
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <K, V> Uni<io.vertx.mutiny.core.shareddata.AsyncMap<K, V>> getLocalAsyncMap(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getLocalAsyncMap(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalAsyncMap(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the map
   * @return the AsyncMap<K,V> instance produced by the operation
   */
  public <K, V> io.vertx.mutiny.core.shareddata.AsyncMap<K, V> getLocalAsyncMapAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.AsyncMap<K, V>) getLocalAsyncMap(name).await().indefinitely();
  }

  /**
   * @param name the name of the lock
   * @param resultHandler the handler
   */
  private void __getLock(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.Lock>> resultHandler) { 
    delegate.getLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.shareddata.Lock> getLock(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getLock(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLock(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @return the Lock instance produced by the operation
   */
  public io.vertx.mutiny.core.shareddata.Lock getLockAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLock(name).await().indefinitely();
  }

  /**
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param resultHandler the handler
   */
  private void __getLockWithTimeout(String name, long timeout, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.Lock>> resultHandler) { 
    delegate.getLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.shareddata.Lock> getLockWithTimeout(String name, long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getLockWithTimeout(name, timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLockWithTimeout(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the Lock instance produced by the operation
   */
  public io.vertx.mutiny.core.shareddata.Lock getLockWithTimeoutAndAwait(String name, long timeout) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLockWithTimeout(name, timeout).await().indefinitely();
  }

  /**
   * @param name the name of the lock
   * @param resultHandler the handler
   */
  private void __getLocalLock(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.Lock>> resultHandler) { 
    delegate.getLocalLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.shareddata.Lock> getLocalLock(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getLocalLock(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @return the Lock instance produced by the operation
   */
  public io.vertx.mutiny.core.shareddata.Lock getLocalLockAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLocalLock(name).await().indefinitely();
  }

  /**
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param resultHandler the handler
   */
  private void __getLocalLockWithTimeout(String name, long timeout, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.Lock>> resultHandler) { 
    delegate.getLocalLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.shareddata.Lock> getLocalLockWithTimeout(String name, long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getLocalLockWithTimeout(name, timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalLockWithTimeout(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return the Lock instance produced by the operation
   */
  public io.vertx.mutiny.core.shareddata.Lock getLocalLockWithTimeoutAndAwait(String name, long timeout) { 
    return (io.vertx.mutiny.core.shareddata.Lock) getLocalLockWithTimeout(name, timeout).await().indefinitely();
  }

  /**
   * @param name the name of the counter.
   * @param resultHandler the handler
   */
  private void __getCounter(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.Counter>> resultHandler) { 
    delegate.getCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.Counter.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the counter.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.shareddata.Counter> getCounter(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getCounter(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getCounter(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the counter.
   * @return the Counter instance produced by the operation
   */
  public io.vertx.mutiny.core.shareddata.Counter getCounterAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Counter) getCounter(name).await().indefinitely();
  }

  /**
   * @param name the name of the counter.
   * @param resultHandler the handler
   */
  private void __getLocalCounter(String name, Handler<AsyncResult<io.vertx.mutiny.core.shareddata.Counter>> resultHandler) { 
    delegate.getLocalCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.shareddata.Counter.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name of the counter.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.shareddata.Counter> getLocalCounter(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getLocalCounter(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.SharedData#getLocalCounter(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name of the counter.
   * @return the Counter instance produced by the operation
   */
  public io.vertx.mutiny.core.shareddata.Counter getLocalCounterAndAwait(String name) { 
    return (io.vertx.mutiny.core.shareddata.Counter) getLocalCounter(name).await().indefinitely();
  }

  /**
   * @param name the name of the map
   * @return the msp
   */
  public <K, V> io.vertx.mutiny.core.shareddata.LocalMap<K, V> getLocalMap(String name) { 
    io.vertx.mutiny.core.shareddata.LocalMap<K, V> ret = io.vertx.mutiny.core.shareddata.LocalMap.newInstance(delegate.getLocalMap(name), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  public static  SharedData newInstance(io.vertx.core.shareddata.SharedData arg) {
    return arg != null ? new SharedData(arg) : null;
  }

}
