package io.vertx.mutiny.core.net;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;

/**
 * A self-signed certificate helper for testing and development purposes.
 * <p>
 * While it helps for testing and development, it should never ever be used in production settings.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SelfSignedCertificate original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.SelfSignedCertificate.class)
public class SelfSignedCertificate {

  public static final io.smallrye.mutiny.vertx.TypeArg<SelfSignedCertificate> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SelfSignedCertificate((io.vertx.core.net.SelfSignedCertificate) obj),
    SelfSignedCertificate::getDelegate
  );

  private final io.vertx.core.net.SelfSignedCertificate delegate;
  
  public SelfSignedCertificate(io.vertx.core.net.SelfSignedCertificate delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  SelfSignedCertificate() {    this.delegate = null;
  }

  public io.vertx.core.net.SelfSignedCertificate getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SelfSignedCertificate that = (SelfSignedCertificate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a {@link io.vertx.core.net.PemKeyCertOptions} based on the generated certificate.
   */
  public PemKeyCertOptions keyCertOptions() { 
    PemKeyCertOptions ret = delegate.keyCertOptions();
    return ret;
  }

  /**
   * @return a {@link io.vertx.core.net.PemTrustOptions} based on the generated certificate.
   */
  public PemTrustOptions trustOptions() { 
    PemTrustOptions ret = delegate.trustOptions();
    return ret;
  }

  /**
   * @return the absolute path to the private key.
   */
  public String privateKeyPath() { 
    String ret = delegate.privateKeyPath();
    return ret;
  }

  /**
   * @return the absolute path to the certificate.
   */
  public String certificatePath() { 
    String ret = delegate.certificatePath();
    return ret;
  }

  /**
   */
  public void delete() { 
    delegate.delete();
  }

  /**
   * @return a new instance.
   */
  public static io.vertx.mutiny.core.net.SelfSignedCertificate create() { 
    io.vertx.mutiny.core.net.SelfSignedCertificate ret = io.vertx.mutiny.core.net.SelfSignedCertificate.newInstance(io.vertx.core.net.SelfSignedCertificate.create());
    return ret;
  }

  /**
   * @param fqdn a fully qualified domain name.
   * @return a new instance.
   */
  public static io.vertx.mutiny.core.net.SelfSignedCertificate create(String fqdn) { 
    io.vertx.mutiny.core.net.SelfSignedCertificate ret = io.vertx.mutiny.core.net.SelfSignedCertificate.newInstance(io.vertx.core.net.SelfSignedCertificate.create(fqdn));
    return ret;
  }

  public static  SelfSignedCertificate newInstance(io.vertx.core.net.SelfSignedCertificate arg) {
    return arg != null ? new SelfSignedCertificate(arg) : null;
  }

}
