package io.vertx.mutiny.core.net;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<NetServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  NetServer() {    this.delegate = null;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.net.NetSocket> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.net.NetSocket>(o1 -> io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @return the connect stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.net.NetSocket> connectStream() { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.net.NetSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.connectStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __connectHandler(Handler<io.vertx.mutiny.core.net.NetSocket> handler) { 
    io.vertx.mutiny.core.net.NetServer ret = io.vertx.mutiny.core.net.NetServer.newInstance(delegate.connectHandler(new Handler<io.vertx.core.net.NetSocket>() {
      public void handle(io.vertx.core.net.NetSocket event) {
        handler.handle(io.vertx.mutiny.core.net.NetSocket.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer connectHandler(Consumer<io.vertx.mutiny.core.net.NetSocket> handler) {
    return __connectHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetServer#listen}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait() { 
    return (io.vertx.mutiny.core.net.NetServer) listen().await().indefinitely();
  }

  /**
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, host, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetServer#listen(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.net.NetServer) listen(port, host).await().indefinitely();
  }

  /**
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(int port, Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen(int port) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetServer#listen(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait(int port) { 
    return (io.vertx.mutiny.core.net.NetServer) listen(port).await().indefinitely();
  }

  /**
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(io.vertx.mutiny.core.net.SocketAddress localAddress, Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen(io.vertx.mutiny.core.net.SocketAddress localAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(localAddress, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetServer#listen(io.vertx.mutiny.core.net.SocketAddress)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait(io.vertx.mutiny.core.net.SocketAddress localAddress) { 
    return (io.vertx.mutiny.core.net.NetServer) listen(localAddress).await().indefinitely();
  }

  /**
   * @param completionHandler the handler
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetServer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetServer#listen} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetServer#listen}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetServer#listen} but you don't need to compose it with other operations.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget() { 
    delegate.listen();
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetServer#listen(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetServer#listen(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetServer#listen(int,String)} but you don't need to compose it with other operations.
   * @param port 
   * @param host 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetServer#listen(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetServer#listen(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetServer#listen(int)} but you don't need to compose it with other operations.
   * @param port 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetServer#listen(io.vertx.mutiny.core.net.SocketAddress)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetServer#listen(io.vertx.mutiny.core.net.SocketAddress)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetServer#listen(io.vertx.mutiny.core.net.SocketAddress)} but you don't need to compose it with other operations.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget(io.vertx.mutiny.core.net.SocketAddress localAddress) { 
    delegate.listen(localAddress.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetServer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetServer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetServer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  public static  NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
