package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.mutiny.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.mutiny.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpServer() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.HttpServerRequest> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.HttpServerRequest>(o1 -> io.vertx.mutiny.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.ServerWebSocket> TYPE_ARG_2 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.ServerWebSocket>(o1 -> io.vertx.mutiny.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.ServerWebSocket> TYPE_ARG_1 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.ServerWebSocket>(o1 -> io.vertx.mutiny.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @return the request stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.HttpServerRequest> requestStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.HttpServerRequest> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.requestStream(), TYPE_ARG_0);
    cached_0 = ret;
    return ret;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __requestHandler(Handler<io.vertx.mutiny.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>() {
      public void handle(io.vertx.core.http.HttpServerRequest event) {
        handler.handle(io.vertx.mutiny.core.http.HttpServerRequest.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer requestHandler(Consumer<io.vertx.mutiny.core.http.HttpServerRequest> handler) {
    return __requestHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __connectionHandler(Handler<io.vertx.mutiny.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.mutiny.core.http.HttpConnection.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer connectionHandler(Consumer<io.vertx.mutiny.core.http.HttpConnection> handler) {
    return __connectionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the WebSocket stream
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> websocketStream() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(), TYPE_ARG_1);
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the WebSocket stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> webSocketStream() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.webSocketStream(), TYPE_ARG_2);
    cached_2 = ret;
    return ret;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpServer __websocketHandler(Handler<io.vertx.mutiny.core.http.ServerWebSocket> handler) { 
    delegate.websocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.mutiny.core.http.ServerWebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpServer websocketHandler(Consumer<io.vertx.mutiny.core.http.ServerWebSocket> handler) {
    return __websocketHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __webSocketHandler(Handler<io.vertx.mutiny.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.mutiny.core.http.ServerWebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer webSocketHandler(Consumer<io.vertx.mutiny.core.http.ServerWebSocket> handler) {
    return __webSocketHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, host, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServer#listen(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the HttpServer instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.http.HttpServer) listen(port, host).await().indefinitely();
  }

  /**
   * @param address the address to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(io.vertx.mutiny.core.net.SocketAddress address, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address the address to listen on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen(io.vertx.mutiny.core.net.SocketAddress address) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(address, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServer#listen(io.vertx.mutiny.core.net.SocketAddress)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address the address to listen on
   * @return the HttpServer instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait(io.vertx.mutiny.core.net.SocketAddress address) { 
    return (io.vertx.mutiny.core.http.HttpServer) listen(address).await().indefinitely();
  }

  /**
   * @param port the port to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(int port, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen(int port) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServer#listen(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @return the HttpServer instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait(int port) { 
    return (io.vertx.mutiny.core.http.HttpServer) listen(port).await().indefinitely();
  }

  /**
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServer#listen}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the HttpServer instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait() { 
    return (io.vertx.mutiny.core.http.HttpServer) listen().await().indefinitely();
  }

  /**
   * @param completionHandler the handler
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServer#listen} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServer#listen}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServer#listen} but you don't need to compose it with other operations.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndForget() { 
    delegate.listen();
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServer#listen(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServer#listen(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServer#listen(int,String)} but you don't need to compose it with other operations.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndForget(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServer#listen(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServer#listen(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServer#listen(int)} but you don't need to compose it with other operations.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndForget(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  private io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.HttpServerRequest> cached_0;
  private io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> cached_1;
  private io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> cached_2;
  public static  HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
