package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * Represents the result of an action that may, or may not, have occurred yet.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Future original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.Future.class)
public class Future<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Future> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Future((io.vertx.core.Future) obj),
    Future::getDelegate
  );

  private final io.vertx.core.Future<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Future(io.vertx.core.Future delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Future(io.vertx.core.Future delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Future() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.Future getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Future that = (Future) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param handler the handler
   * @return the future.
   */
  private static <T> io.vertx.mutiny.core.Future<T> __future(Handler<io.vertx.mutiny.core.Promise<T>> handler) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(io.vertx.core.Future.future(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        handler.handle(io.vertx.mutiny.core.Promise.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param handler the handler
   * @return the future.
   */
  public static <T> io.vertx.mutiny.core.Future<T> future(Consumer<io.vertx.mutiny.core.Promise<T>> handler) {
    return __future(handler != null ? handler::accept : null);
  }

  /**
   * @return the future
   */
  @Deprecated
  public static <T> io.vertx.mutiny.core.Future<T> future() { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(io.vertx.core.Future.future(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the future
   */
  public static <T> io.vertx.mutiny.core.Future<T> succeededFuture() { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(io.vertx.core.Future.succeededFuture(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param result the result
   * @return the future
   */
  public static <T> io.vertx.mutiny.core.Future<T> succeededFuture(T result) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(io.vertx.core.Future.succeededFuture(result), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param t the failure cause as a Throwable
   * @return the future
   */
  public static <T> io.vertx.mutiny.core.Future<T> failedFuture(Throwable t) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(io.vertx.core.Future.failedFuture(t), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param failureMessage the failure message
   * @return the future
   */
  public static <T> io.vertx.mutiny.core.Future<T> failedFuture(String failureMessage) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(io.vertx.core.Future.failedFuture(failureMessage), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return true if completed, false if not
   */
  public boolean isComplete() { 
    boolean ret = delegate.isComplete();
    return ret;
  }

  /**
   * @param handler 
   * @return 
   */
  @Deprecated
  private io.vertx.mutiny.core.Future<T> __setHandler(Handler<AsyncResult<T>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.Future#onComplete}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @Deprecated
  public Uni<T> setHandler() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __setHandler(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Future#setHandler}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the T instance produced by the operation
   */
  @Deprecated
  public T setHandlerAndAwait() { 
    return (T) setHandler().await().indefinitely();
  }

  /**
   * @param handler the handler that will be called with the result
   * @return a reference to this, so it can be used fluently
   */
  private io.vertx.mutiny.core.Future<T> __onComplete(Handler<AsyncResult<T>> handler) { 
    delegate.onComplete(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Add a handler to be notified of the result.
   * <br/>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return a reference to this, so it can be used fluently
   */
  public Uni<T> onComplete() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __onComplete(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Future#onComplete}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return a reference to this, so it can be used fluently
   */
  public T onCompleteAndAwait() { 
    return (T) onComplete().await().indefinitely();
  }

  /**
   * @param handler the handler that will be called with the succeeded result
   * @return a reference to this, so it can be used fluently
   */
  private io.vertx.mutiny.core.Future<T> __onSuccess(Handler<T> handler) { 
    delegate.onSuccess(new Handler<T>() {
      public void handle(T event) {
        handler.handle((T)__typeArg_0.wrap(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler that will be called with the succeeded result
   * @return a reference to this, so it can be used fluently
   */
  public io.vertx.mutiny.core.Future<T> onSuccess(Consumer<T> handler) {
    return __onSuccess(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler that will be called with the failed result
   * @return a reference to this, so it can be used fluently
   */
  private io.vertx.mutiny.core.Future<T> __onFailure(Handler<Throwable> handler) { 
    delegate.onFailure(handler);
    return this;
  }

  /**
   * @param handler the handler that will be called with the failed result
   * @return a reference to this, so it can be used fluently
   */
  public io.vertx.mutiny.core.Future<T> onFailure(Consumer<Throwable> handler) {
    return __onFailure(handler != null ? handler::accept : null);
  }

  /**
   * @param result the result
   */
  @Deprecated
  public void complete(T result) { 
    delegate.complete(__typeArg_0.<T>unwrap(result));
  }

  /**
   */
  @Deprecated
  public void complete() { 
    delegate.complete();
  }

  /**
   * @param cause the failure cause
   */
  @Deprecated
  public void fail(Throwable cause) { 
    delegate.fail(cause);
  }

  /**
   * @param failureMessage the failure message
   */
  @Deprecated
  public void fail(String failureMessage) { 
    delegate.fail(failureMessage);
  }

  /**
   * @param result the result
   * @return false when the future is already completed
   */
  @Deprecated
  public boolean tryComplete(T result) { 
    boolean ret = delegate.tryComplete(__typeArg_0.<T>unwrap(result));
    return ret;
  }

  /**
   * @return false when the future is already completed
   */
  @Deprecated
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * @param cause the failure cause
   * @return false when the future is already completed
   */
  @Deprecated
  public boolean tryFail(Throwable cause) { 
    boolean ret = delegate.tryFail(cause);
    return ret;
  }

  /**
   * @param failureMessage the failure message
   * @return false when the future is already completed
   */
  @Deprecated
  public boolean tryFail(String failureMessage) { 
    boolean ret = delegate.tryFail(failureMessage);
    return ret;
  }

  /**
   * @return the result or null if the operation failed.
   */
  public T result() { 
    T ret = (T)__typeArg_0.wrap(delegate.result());
    return ret;
  }

  /**
   * @return the cause or null if the operation succeeded.
   */
  public Throwable cause() { 
    Throwable ret = delegate.cause();
    return ret;
  }

  /**
   * @return true if it succeded or false otherwise
   */
  public boolean succeeded() { 
    boolean ret = delegate.succeeded();
    return ret;
  }

  /**
   * @return true if it failed or false otherwise
   */
  public boolean failed() { 
    boolean ret = delegate.failed();
    return ret;
  }

  /**
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.mutiny.core.Future<U> flatMap(Function<T, io.vertx.mutiny.core.Future<U>> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.flatMap(new java.util.function.Function<T,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(T arg) {
        io.vertx.mutiny.core.Future<U> ret = mapper.apply((T)__typeArg_0.wrap(arg));
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> io.vertx.mutiny.core.Future<U> compose(Function<T, io.vertx.mutiny.core.Future<U>> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.compose(new java.util.function.Function<T,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(T arg) {
        io.vertx.mutiny.core.Future<U> ret = mapper.apply((T)__typeArg_0.wrap(arg));
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param successMapper the function mapping the success
   * @param failureMapper the function mapping the failure
   * @return the composed future
   */
  public <U> io.vertx.mutiny.core.Future<U> compose(Function<T, io.vertx.mutiny.core.Future<U>> successMapper, Function<Throwable, io.vertx.mutiny.core.Future<U>> failureMapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.compose(new java.util.function.Function<T,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(T arg) {
        io.vertx.mutiny.core.Future<U> ret = successMapper.apply((T)__typeArg_0.wrap(arg));
        return ret.getDelegate();
      }
    }, new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.Future<U> ret = failureMapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> io.vertx.mutiny.core.Future<U> map(Function<T, U> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.map(new java.util.function.Function<T,U>() {
      public U apply(T arg) {
        U ret = mapper.apply((T)__typeArg_0.wrap(arg));
        return ret;
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public <V> io.vertx.mutiny.core.Future<V> map(V value) { 
    io.vertx.mutiny.core.Future<V> ret = io.vertx.mutiny.core.Future.newInstance(delegate.map(value), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the mapped future
   */
  public <V> io.vertx.mutiny.core.Future<V> mapEmpty() { 
    io.vertx.mutiny.core.Future<V> ret = io.vertx.mutiny.core.Future.newInstance(delegate.mapEmpty(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  @Deprecated
  public Handler<AsyncResult<T>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<T>> ret = new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(__typeArg_0.<T>unwrap(ar.result())));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public io.vertx.mutiny.core.Future<T> recover(Function<Throwable, io.vertx.mutiny.core.Future<T>> mapper) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.Future<T> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), __typeArg_0);
    return ret;
  }

  /**
   * @param mapper the mapper function
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<T> otherwise(Function<Throwable, T> mapper) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwise(new java.util.function.Function<java.lang.Throwable,T>() {
      public T apply(java.lang.Throwable arg) {
        T ret = mapper.apply(arg);
        return __typeArg_0.<T>unwrap(ret);
      }
    }), __typeArg_0);
    return ret;
  }

  /**
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<T> otherwise(T value) { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwise(__typeArg_0.<T>unwrap(value)), __typeArg_0);
    return ret;
  }

  /**
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<T> otherwiseEmpty() { 
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwiseEmpty(), __typeArg_0);
    return ret;
  }

  private Handler<AsyncResult<T>> cached_0;
  public static <T>Future<T> newInstance(io.vertx.core.Future arg) {
    return arg != null ? new Future<T>(arg) : null;
  }


  public static <T>Future<T> newInstance(io.vertx.core.Future arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Future<T>(arg, __typeArg_T) : null;
  }

}
