package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * The composite future wraps a list of {@link io.vertx.mutiny.core.Future futures}, it is useful when several futures
 * needs to be coordinated.
 * The handlers set for the coordinated futures are overridden by the handler of the composite future.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.CompositeFuture original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.CompositeFuture.class)
public class CompositeFuture extends io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> {

  public static final io.smallrye.mutiny.vertx.TypeArg<CompositeFuture> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CompositeFuture((io.vertx.core.CompositeFuture) obj),
    CompositeFuture::getDelegate
  );

  private final io.vertx.core.CompositeFuture delegate;
  
  public CompositeFuture(io.vertx.core.CompositeFuture delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  CompositeFuture() {    super(null);
    this.delegate = null;
  }

  public io.vertx.core.CompositeFuture getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture> TYPE_ARG_1 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture>(o1 -> io.vertx.mutiny.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture> TYPE_ARG_3 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture>(o1 -> io.vertx.mutiny.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture> TYPE_ARG_2 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture>(o1 -> io.vertx.mutiny.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.CompositeFuture>(o1 -> io.vertx.mutiny.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CompositeFuture that = (CompositeFuture) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param result the result
   */
  @Deprecated
  public void complete(io.vertx.mutiny.core.CompositeFuture result) { 
    delegate.complete(result.getDelegate());
  }

  /**
   * @param result the result
   * @return false when the future is already completed
   */
  @Deprecated
  public boolean tryComplete(io.vertx.mutiny.core.CompositeFuture result) { 
    boolean ret = delegate.tryComplete(result.getDelegate());
    return ret;
  }

  /**
   * @return the result or null if the operation failed.
   */
  public io.vertx.mutiny.core.CompositeFuture result() { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(delegate.result());
    return ret;
  }

  /**
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.mutiny.core.Future<U> flatMap(Function<io.vertx.mutiny.core.CompositeFuture, io.vertx.mutiny.core.Future<U>> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.flatMap(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.mutiny.core.Future<U> ret = mapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> io.vertx.mutiny.core.Future<U> compose(Function<io.vertx.mutiny.core.CompositeFuture, io.vertx.mutiny.core.Future<U>> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.mutiny.core.Future<U> ret = mapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param successMapper the function mapping the success
   * @param failureMapper the function mapping the failure
   * @return the composed future
   */
  public <U> io.vertx.mutiny.core.Future<U> compose(Function<io.vertx.mutiny.core.CompositeFuture, io.vertx.mutiny.core.Future<U>> successMapper, Function<Throwable, io.vertx.mutiny.core.Future<U>> failureMapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.mutiny.core.Future<U> ret = successMapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }, new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.Future<U> ret = failureMapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> io.vertx.mutiny.core.Future<U> map(Function<io.vertx.mutiny.core.CompositeFuture, U> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.map(new java.util.function.Function<io.vertx.core.CompositeFuture,U>() {
      public U apply(io.vertx.core.CompositeFuture arg) {
        U ret = mapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret;
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  @Deprecated
  public Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> ret = new Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.mutiny.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> recover(Function<Throwable, io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture>> mapper) { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<io.vertx.core.CompositeFuture>>() {
      public io.vertx.core.Future<io.vertx.core.CompositeFuture> apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param mapper the mapper function
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> otherwise(Function<Throwable, io.vertx.mutiny.core.CompositeFuture> mapper) { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwise(new java.util.function.Function<java.lang.Throwable,io.vertx.core.CompositeFuture>() {
      public io.vertx.core.CompositeFuture apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.CompositeFuture ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> otherwise(io.vertx.mutiny.core.CompositeFuture value) { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwise(value.getDelegate()), TYPE_ARG_2);
    return ret;
  }

  /**
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> otherwiseEmpty() { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwiseEmpty(), TYPE_ARG_3);
    return ret;
  }

  /**
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5, io.vertx.mutiny.core.Future<T6> f6) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * @param futures 
   * @return 
   */
  public static io.vertx.mutiny.core.CompositeFuture all(List<io.vertx.mutiny.core.Future> futures) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5, io.vertx.mutiny.core.Future<T6> f6) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * @param futures 
   * @return 
   */
  public static io.vertx.mutiny.core.CompositeFuture any(List<io.vertx.mutiny.core.Future> futures) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5, io.vertx.mutiny.core.Future<T6> f6) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * @param futures 
   * @return 
   */
  public static io.vertx.mutiny.core.CompositeFuture join(List<io.vertx.mutiny.core.Future> futures) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  @Deprecated
  private io.vertx.mutiny.core.CompositeFuture __setHandler(Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  @Deprecated
  public Uni<io.vertx.mutiny.core.CompositeFuture> setHandler() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __setHandler(handler);
    });
  }

  @Deprecated
  public io.vertx.mutiny.core.CompositeFuture setHandlerAndAwait() { 
    return (io.vertx.mutiny.core.CompositeFuture) setHandler().await().indefinitely();
  }

  private io.vertx.mutiny.core.CompositeFuture __onComplete(Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> handler) { 
    delegate.onComplete(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Uni<io.vertx.mutiny.core.CompositeFuture> onComplete() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __onComplete(handler);
    });
  }

  public io.vertx.mutiny.core.CompositeFuture onCompleteAndAwait() { 
    return (io.vertx.mutiny.core.CompositeFuture) onComplete().await().indefinitely();
  }

  private io.vertx.mutiny.core.CompositeFuture __onSuccess(Handler<io.vertx.mutiny.core.CompositeFuture> handler) { 
    delegate.onSuccess(new Handler<io.vertx.core.CompositeFuture>() {
      public void handle(io.vertx.core.CompositeFuture event) {
        handler.handle(io.vertx.mutiny.core.CompositeFuture.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.CompositeFuture onSuccess(Consumer<io.vertx.mutiny.core.CompositeFuture> handler) {
    return __onSuccess(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.CompositeFuture __onFailure(Handler<Throwable> handler) { 
    delegate.onFailure(handler);
    return this;
  }

  public io.vertx.mutiny.core.CompositeFuture onFailure(Consumer<Throwable> handler) {
    return __onFailure(handler != null ? handler::accept : null);
  }

  /**
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * @return false when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * @param index the wrapped future index
   * @return 
   */
  public Throwable cause(int index) { 
    Throwable ret = delegate.cause(index);
    return ret;
  }

  /**
   * @param index the wrapped future index
   * @return 
   */
  public boolean succeeded(int index) { 
    boolean ret = delegate.succeeded(index);
    return ret;
  }

  /**
   * @param index the wrapped future index
   * @return 
   */
  public boolean failed(int index) { 
    boolean ret = delegate.failed(index);
    return ret;
  }

  /**
   * @param index the wrapped future index
   * @return 
   */
  public boolean isComplete(int index) { 
    boolean ret = delegate.isComplete(index);
    return ret;
  }

  /**
   * @param index the wrapped future index
   * @return 
   */
  public <T> T resultAt(int index) { 
    T ret = (T) delegate.resultAt(index);
    return ret;
  }

  /**
   * @return the number of wrapped future
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  private Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> cached_0;
  public static  CompositeFuture newInstance(io.vertx.core.CompositeFuture arg) {
    return arg != null ? new CompositeFuture(arg) : null;
  }

}
