/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

public enum Opcode {
    NOP(0, 1, Kind.NOP),
    ACONST_NULL(1, 1, Kind.CONSTANT),
    ICONST_M1(2, 1, Kind.CONSTANT),
    ICONST_0(3, 1, Kind.CONSTANT),
    ICONST_1(4, 1, Kind.CONSTANT),
    ICONST_2(5, 1, Kind.CONSTANT),
    ICONST_3(6, 1, Kind.CONSTANT),
    ICONST_4(7, 1, Kind.CONSTANT),
    ICONST_5(8, 1, Kind.CONSTANT),
    LCONST_0(9, 1, Kind.CONSTANT),
    LCONST_1(10, 1, Kind.CONSTANT),
    FCONST_0(11, 1, Kind.CONSTANT),
    FCONST_1(12, 1, Kind.CONSTANT),
    FCONST_2(13, 1, Kind.CONSTANT),
    DCONST_0(14, 1, Kind.CONSTANT),
    DCONST_1(15, 1, Kind.CONSTANT),
    BIPUSH(16, 2, Kind.CONSTANT),
    SIPUSH(17, 3, Kind.CONSTANT),
    LDC(18, 2, Kind.CONSTANT),
    LDC_W(19, 3, Kind.CONSTANT),
    LDC2_W(20, 3, Kind.CONSTANT),
    ILOAD(21, 2, Kind.LOAD),
    LLOAD(22, 2, Kind.LOAD),
    FLOAD(23, 2, Kind.LOAD),
    DLOAD(24, 2, Kind.LOAD),
    ALOAD(25, 2, Kind.LOAD),
    ILOAD_0(26, 1, Kind.LOAD),
    ILOAD_1(27, 1, Kind.LOAD),
    ILOAD_2(28, 1, Kind.LOAD),
    ILOAD_3(29, 1, Kind.LOAD),
    LLOAD_0(30, 1, Kind.LOAD),
    LLOAD_1(31, 1, Kind.LOAD),
    LLOAD_2(32, 1, Kind.LOAD),
    LLOAD_3(33, 1, Kind.LOAD),
    FLOAD_0(34, 1, Kind.LOAD),
    FLOAD_1(35, 1, Kind.LOAD),
    FLOAD_2(36, 1, Kind.LOAD),
    FLOAD_3(37, 1, Kind.LOAD),
    DLOAD_0(38, 1, Kind.LOAD),
    DLOAD_1(39, 1, Kind.LOAD),
    DLOAD_2(40, 1, Kind.LOAD),
    DLOAD_3(41, 1, Kind.LOAD),
    ALOAD_0(42, 1, Kind.LOAD),
    ALOAD_1(43, 1, Kind.LOAD),
    ALOAD_2(44, 1, Kind.LOAD),
    ALOAD_3(45, 1, Kind.LOAD),
    IALOAD(46, 1, Kind.ARRAY_LOAD),
    LALOAD(47, 1, Kind.ARRAY_LOAD),
    FALOAD(48, 1, Kind.ARRAY_LOAD),
    DALOAD(49, 1, Kind.ARRAY_LOAD),
    AALOAD(50, 1, Kind.ARRAY_LOAD),
    BALOAD(51, 1, Kind.ARRAY_LOAD),
    CALOAD(52, 1, Kind.ARRAY_LOAD),
    SALOAD(53, 1, Kind.ARRAY_LOAD),
    ISTORE(54, 2, Kind.STORE),
    LSTORE(55, 2, Kind.STORE),
    FSTORE(56, 2, Kind.STORE),
    DSTORE(57, 2, Kind.STORE),
    ASTORE(58, 2, Kind.STORE),
    ISTORE_0(59, 1, Kind.STORE),
    ISTORE_1(60, 1, Kind.STORE),
    ISTORE_2(61, 1, Kind.STORE),
    ISTORE_3(62, 1, Kind.STORE),
    LSTORE_0(63, 1, Kind.STORE),
    LSTORE_1(64, 1, Kind.STORE),
    LSTORE_2(65, 1, Kind.STORE),
    LSTORE_3(66, 1, Kind.STORE),
    FSTORE_0(67, 1, Kind.STORE),
    FSTORE_1(68, 1, Kind.STORE),
    FSTORE_2(69, 1, Kind.STORE),
    FSTORE_3(70, 1, Kind.STORE),
    DSTORE_0(71, 1, Kind.STORE),
    DSTORE_1(72, 1, Kind.STORE),
    DSTORE_2(73, 1, Kind.STORE),
    DSTORE_3(74, 1, Kind.STORE),
    ASTORE_0(75, 1, Kind.STORE),
    ASTORE_1(76, 1, Kind.STORE),
    ASTORE_2(77, 1, Kind.STORE),
    ASTORE_3(78, 1, Kind.STORE),
    IASTORE(79, 1, Kind.ARRAY_STORE),
    LASTORE(80, 1, Kind.ARRAY_STORE),
    FASTORE(81, 1, Kind.ARRAY_STORE),
    DASTORE(82, 1, Kind.ARRAY_STORE),
    AASTORE(83, 1, Kind.ARRAY_STORE),
    BASTORE(84, 1, Kind.ARRAY_STORE),
    CASTORE(85, 1, Kind.ARRAY_STORE),
    SASTORE(86, 1, Kind.ARRAY_STORE),
    POP(87, 1, Kind.STACK),
    POP2(88, 1, Kind.STACK),
    DUP(89, 1, Kind.STACK),
    DUP_X1(90, 1, Kind.STACK),
    DUP_X2(91, 1, Kind.STACK),
    DUP2(92, 1, Kind.STACK),
    DUP2_X1(93, 1, Kind.STACK),
    DUP2_X2(94, 1, Kind.STACK),
    SWAP(95, 1, Kind.STACK),
    IADD(96, 1, Kind.OPERATOR),
    LADD(97, 1, Kind.OPERATOR),
    FADD(98, 1, Kind.OPERATOR),
    DADD(99, 1, Kind.OPERATOR),
    ISUB(100, 1, Kind.OPERATOR),
    LSUB(101, 1, Kind.OPERATOR),
    FSUB(102, 1, Kind.OPERATOR),
    DSUB(103, 1, Kind.OPERATOR),
    IMUL(104, 1, Kind.OPERATOR),
    LMUL(105, 1, Kind.OPERATOR),
    FMUL(106, 1, Kind.OPERATOR),
    DMUL(107, 1, Kind.OPERATOR),
    IDIV(108, 1, Kind.OPERATOR),
    LDIV(109, 1, Kind.OPERATOR),
    FDIV(110, 1, Kind.OPERATOR),
    DDIV(111, 1, Kind.OPERATOR),
    IREM(112, 1, Kind.OPERATOR),
    LREM(113, 1, Kind.OPERATOR),
    FREM(114, 1, Kind.OPERATOR),
    DREM(115, 1, Kind.OPERATOR),
    INEG(116, 1, Kind.OPERATOR),
    LNEG(117, 1, Kind.OPERATOR),
    FNEG(118, 1, Kind.OPERATOR),
    DNEG(119, 1, Kind.OPERATOR),
    ISHL(120, 1, Kind.OPERATOR),
    LSHL(121, 1, Kind.OPERATOR),
    ISHR(122, 1, Kind.OPERATOR),
    LSHR(123, 1, Kind.OPERATOR),
    IUSHR(124, 1, Kind.OPERATOR),
    LUSHR(125, 1, Kind.OPERATOR),
    IAND(126, 1, Kind.OPERATOR),
    LAND(127, 1, Kind.OPERATOR),
    IOR(128, 1, Kind.OPERATOR),
    LOR(129, 1, Kind.OPERATOR),
    IXOR(130, 1, Kind.OPERATOR),
    LXOR(131, 1, Kind.OPERATOR),
    IINC(132, 3, Kind.INCREMENT),
    I2L(133, 1, Kind.CONVERT),
    I2F(134, 1, Kind.CONVERT),
    I2D(135, 1, Kind.CONVERT),
    L2I(136, 1, Kind.CONVERT),
    L2F(137, 1, Kind.CONVERT),
    L2D(138, 1, Kind.CONVERT),
    F2I(139, 1, Kind.CONVERT),
    F2L(140, 1, Kind.CONVERT),
    F2D(141, 1, Kind.CONVERT),
    D2I(142, 1, Kind.CONVERT),
    D2L(143, 1, Kind.CONVERT),
    D2F(144, 1, Kind.CONVERT),
    I2B(145, 1, Kind.CONVERT),
    I2C(146, 1, Kind.CONVERT),
    I2S(147, 1, Kind.CONVERT),
    LCMP(148, 1, Kind.OPERATOR),
    FCMPL(149, 1, Kind.OPERATOR),
    FCMPG(150, 1, Kind.OPERATOR),
    DCMPL(151, 1, Kind.OPERATOR),
    DCMPG(152, 1, Kind.OPERATOR),
    IFEQ(153, 3, Kind.BRANCH),
    IFNE(154, 3, Kind.BRANCH),
    IFLT(155, 3, Kind.BRANCH),
    IFGE(156, 3, Kind.BRANCH),
    IFGT(157, 3, Kind.BRANCH),
    IFLE(158, 3, Kind.BRANCH),
    IF_ICMPEQ(159, 3, Kind.BRANCH),
    IF_ICMPNE(160, 3, Kind.BRANCH),
    IF_ICMPLT(161, 3, Kind.BRANCH),
    IF_ICMPGE(162, 3, Kind.BRANCH),
    IF_ICMPGT(163, 3, Kind.BRANCH),
    IF_ICMPLE(164, 3, Kind.BRANCH),
    IF_ACMPEQ(165, 3, Kind.BRANCH),
    IF_ACMPNE(166, 3, Kind.BRANCH),
    GOTO(167, 3, Kind.BRANCH),
    JSR(168, 3, Kind.DISCONTINUED_JSR),
    RET(169, 2, Kind.DISCONTINUED_RET),
    TABLESWITCH(170, -1, Kind.TABLE_SWITCH),
    LOOKUPSWITCH(171, -1, Kind.LOOKUP_SWITCH),
    IRETURN(172, 1, Kind.RETURN),
    LRETURN(173, 1, Kind.RETURN),
    FRETURN(174, 1, Kind.RETURN),
    DRETURN(175, 1, Kind.RETURN),
    ARETURN(176, 1, Kind.RETURN),
    RETURN(177, 1, Kind.RETURN),
    GETSTATIC(178, 3, Kind.FIELD_ACCESS),
    PUTSTATIC(179, 3, Kind.FIELD_ACCESS),
    GETFIELD(180, 3, Kind.FIELD_ACCESS),
    PUTFIELD(181, 3, Kind.FIELD_ACCESS),
    INVOKEVIRTUAL(182, 3, Kind.INVOKE),
    INVOKESPECIAL(183, 3, Kind.INVOKE),
    INVOKESTATIC(184, 3, Kind.INVOKE),
    INVOKEINTERFACE(185, 5, Kind.INVOKE),
    INVOKEDYNAMIC(186, 5, Kind.INVOKE_DYNAMIC),
    NEW(187, 3, Kind.NEW_OBJECT),
    NEWARRAY(188, 2, Kind.NEW_PRIMITIVE_ARRAY),
    ANEWARRAY(189, 3, Kind.NEW_REF_ARRAY),
    ARRAYLENGTH(190, 1, Kind.OPERATOR),
    ATHROW(191, 1, Kind.THROW_EXCEPTION),
    CHECKCAST(192, 3, Kind.TYPE_CHECK),
    INSTANCEOF(193, 3, Kind.TYPE_CHECK),
    MONITORENTER(194, 1, Kind.MONITOR),
    MONITOREXIT(195, 1, Kind.MONITOR),
    MULTIANEWARRAY(197, 4, Kind.NEW_MULTI_ARRAY),
    IFNULL(198, 3, Kind.BRANCH),
    IFNONNULL(199, 3, Kind.BRANCH),
    GOTO_W(200, 5, Kind.BRANCH),
    JSR_W(201, 5, Kind.DISCONTINUED_JSR),
    ILOAD_W(50197, 4, Kind.LOAD),
    LLOAD_W(50198, 4, Kind.LOAD),
    FLOAD_W(50199, 4, Kind.LOAD),
    DLOAD_W(50200, 4, Kind.LOAD),
    ALOAD_W(50201, 4, Kind.LOAD),
    ISTORE_W(50230, 4, Kind.STORE),
    LSTORE_W(50231, 4, Kind.STORE),
    FSTORE_W(50232, 4, Kind.STORE),
    DSTORE_W(50233, 4, Kind.STORE),
    ASTORE_W(50234, 4, Kind.STORE),
    RET_W(50345, 4, Kind.DISCONTINUED_RET),
    IINC_W(50308, 6, Kind.INCREMENT);

    private final int bytecode;
    private final int sizeIfFixed;
    private final Kind kind;

    private Opcode(int bytecode, int sizeIfFixed, Kind kind) {
        this.bytecode = bytecode;
        this.sizeIfFixed = sizeIfFixed;
        this.kind = kind;
    }

    public int bytecode() {
        return this.bytecode;
    }

    public boolean isWide() {
        return this.bytecode > 255;
    }

    public int sizeIfFixed() {
        return this.sizeIfFixed;
    }

    public Kind kind() {
        return this.kind;
    }

    public static enum Kind {
        LOAD,
        STORE,
        INCREMENT,
        BRANCH,
        LOOKUP_SWITCH,
        TABLE_SWITCH,
        RETURN,
        THROW_EXCEPTION,
        FIELD_ACCESS,
        INVOKE,
        INVOKE_DYNAMIC,
        NEW_OBJECT,
        NEW_PRIMITIVE_ARRAY,
        NEW_REF_ARRAY,
        NEW_MULTI_ARRAY,
        TYPE_CHECK,
        ARRAY_LOAD,
        ARRAY_STORE,
        STACK,
        CONVERT,
        OPERATOR,
        CONSTANT,
        MONITOR,
        NOP,
        DISCONTINUED_JSR,
        DISCONTINUED_RET;

    }
}

