/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Results;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Booleans {
    private Booleans() {
    }

    public static boolean isFalsy(Object value) {
        if (value == null || Results.isNotFound(value)) {
            return true;
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool == false;
        }
        if (value instanceof AtomicBoolean) {
            AtomicBoolean atomicBool = (AtomicBoolean)value;
            return !atomicBool.get();
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            return col.isEmpty();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof CharSequence) {
            CharSequence cs = (CharSequence)value;
            return cs.length() == 0;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            return Booleans.isZero(num);
        }
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            return opt.isEmpty();
        }
        if (value instanceof OptionalInt) {
            OptionalInt opt = (OptionalInt)value;
            return opt.isEmpty();
        }
        if (value instanceof OptionalLong) {
            OptionalLong opt = (OptionalLong)value;
            return opt.isEmpty();
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble opt = (OptionalDouble)value;
            return opt.isEmpty();
        }
        return false;
    }

    private static boolean isZero(Number number) {
        if (number instanceof BigDecimal) {
            return BigDecimal.ZERO.compareTo((BigDecimal)number) == 0;
        }
        if (number instanceof BigInteger) {
            return BigInteger.ZERO.equals(number);
        }
        if (number instanceof Float || number instanceof Double) {
            return number.doubleValue() == 0.0;
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return number.longValue() == 0L;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(number.toString())) == 0;
    }
}

