/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parser;
import io.quarkus.qute.TemplateNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Expressions {
    public static final String TYPECHECK_NAMESPACE_PLACEHOLDER = "$$namespace$$";
    static final String LEFT_BRACKET = "(";
    static final String RIGHT_BRACKET = ")";
    static final String SQUARE_LEFT_BRACKET = "[";
    static final String SQUARE_RIGHT_BRACKET = "]";
    public static final char TYPE_INFO_SEPARATOR = '|';
    private static final SplitConfig DEFAULT_SPLIT_CONFIG = new DefaultSplitConfig();
    private static final SplitConfig PARAMS_SPLIT_CONFIG = new SplitConfig(){

        @Override
        public boolean isSeparator(char candidate) {
            return ',' == candidate;
        }

        @Override
        public boolean isInfixNotationSupported() {
            return false;
        }
    };
    private static final SplitConfig TYPE_INFO_SPLIT_CONFIG = new DefaultSplitConfig(){

        @Override
        public boolean isLiteralSeparator(char candidate) {
            return candidate == '|' || LiteralSupport.isStringLiteralSeparator(candidate);
        }
    };

    private Expressions() {
    }

    public static boolean isVirtualMethod(String value) {
        return value.indexOf(LEFT_BRACKET) != -1;
    }

    public static boolean isBracketNotation(String value) {
        return value.startsWith(SQUARE_LEFT_BRACKET);
    }

    public static String parseVirtualMethodName(String value) {
        int start = value.indexOf(LEFT_BRACKET);
        return value.substring(0, start);
    }

    public static List<String> parseVirtualMethodParams(String value, TemplateNode.Origin origin, String exprValue) {
        int start = value.indexOf(LEFT_BRACKET);
        if (start != -1 && value.endsWith(RIGHT_BRACKET)) {
            String params = value.substring(start + 1, value.length() - 1);
            return Expressions.splitParts(params, PARAMS_SPLIT_CONFIG);
        }
        throw Parser.parserError("invalid virtual method in {" + exprValue + "}", origin);
    }

    public static String parseBracketContent(String value, TemplateNode.Origin origin, String exprValue) {
        if (value.endsWith(SQUARE_RIGHT_BRACKET)) {
            return value.substring(1, value.length() - 1);
        }
        throw Parser.parserError("invalid bracket notation expression in {" + exprValue + "}", origin);
    }

    public static String buildVirtualMethodSignature(String name, List<String> params) {
        return name + LEFT_BRACKET + params.stream().collect(Collectors.joining(",")) + RIGHT_BRACKET;
    }

    public static List<String> splitParts(String value) {
        return Expressions.splitParts(value, DEFAULT_SPLIT_CONFIG);
    }

    public static List<String> splitTypeInfoParts(String value) {
        return Expressions.splitParts(value, TYPE_INFO_SPLIT_CONFIG);
    }

    public static List<String> splitParts(String value, SplitConfig splitConfig) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        boolean literal = false;
        char separator = '\u0000';
        int infix = 0;
        int brackets = 0;
        ImmutableList.Builder<String> parts = ImmutableList.builder();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (splitConfig.isSeparator(c)) {
                if (separator != '\u0000' && separator == c) continue;
                if (!literal && brackets == 0 && infix == 0) {
                    if (splitConfig.shouldPrependSeparator(c)) {
                        buffer.append(c);
                    }
                    if (Expressions.addPart(buffer, parts)) {
                        buffer = new StringBuilder();
                    }
                    if (splitConfig.shouldAppendSeparator(c)) {
                        buffer.append(c);
                    }
                    separator = c;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (splitConfig.isLiteralSeparator(c)) {
                boolean bl = literal = !literal;
            }
            if (!literal) {
                if (brackets == 0 && c == ' ' && splitConfig.isInfixNotationSupported()) {
                    if (separator != '\u0000' || buffer.length() != 0 && buffer.charAt(buffer.length() - 1) != '(') {
                        if (infix == 1) {
                            buffer.append(LEFT_BRACKET);
                            infix = (byte)(infix + 1);
                        } else if (infix == 2) {
                            infix = 1;
                            buffer.append(RIGHT_BRACKET);
                            if (Expressions.addPart(buffer, parts)) {
                                buffer = new StringBuilder();
                            }
                        } else {
                            infix = (byte)(infix + 1);
                            if (Expressions.addPart(buffer, parts)) {
                                buffer = new StringBuilder();
                            }
                        }
                    }
                } else {
                    if (Parser.isLeftBracket(c)) {
                        brackets = (byte)(brackets + 1);
                    } else if (Parser.isRightBracket(c)) {
                        brackets = (byte)(brackets - 1);
                    }
                    buffer.append(c);
                }
                separator = '\u0000';
                continue;
            }
            buffer.append(c);
            separator = '\u0000';
        }
        if (infix > 0) {
            buffer.append(RIGHT_BRACKET);
        }
        Expressions.addPart(buffer, parts);
        return parts.build();
    }

    public static String typeInfoFrom(String typeName) {
        return "|" + typeName + "|";
    }

    private static boolean addPart(StringBuilder buffer, ImmutableList.Builder<String> parts) {
        if (buffer.length() == 0) {
            return false;
        }
        String val = buffer.toString().trim();
        if (!val.isEmpty()) {
            parts.add(val);
        }
        return true;
    }

    static interface SplitConfig {
        public boolean isSeparator(char var1);

        default public boolean isLiteralSeparator(char candidate) {
            return LiteralSupport.isStringLiteralSeparator(candidate);
        }

        default public boolean shouldPrependSeparator(char candidate) {
            return false;
        }

        default public boolean shouldAppendSeparator(char candidate) {
            return false;
        }

        default public boolean isInfixNotationSupported() {
            return true;
        }
    }

    private static class DefaultSplitConfig
    implements SplitConfig {
        private DefaultSplitConfig() {
        }

        @Override
        public boolean isSeparator(char candidate) {
            return candidate == '.' || candidate == '[' || candidate == ']';
        }

        @Override
        public boolean shouldPrependSeparator(char candidate) {
            return candidate == ']';
        }

        @Override
        public boolean shouldAppendSeparator(char candidate) {
            return candidate == '[';
        }
    }
}

